/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.LettoEnvFile;
import at.letto.setupservice.configFiles.MysqlEnvFile;
import at.letto.setupservice.configFiles.SetupEnvFile;
import at.letto.setupservice.service.LettoService;
import java.util.HashMap;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DockerConfiguration {
    private MicroServiceConfiguration microServiceConfiguration;
    private LettoService lettoService;
    private SetupEnvFile setupEnvFile;
    private LettoEnvFile lettoEnvFile;
    private MysqlEnvFile mysqlEnvFile;
    public static SetupEnvFile staticSetupEnvFile = null;
    private HashMap<String, String> setupConfig = null;

    public DockerConfiguration(MicroServiceConfiguration microServiceConfiguration, LettoService lettoService) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.lettoService = lettoService;
        this.loadConfiguration();
    }

    public void loadConfiguration() {
        staticSetupEnvFile = this.setupEnvFile = new SetupEnvFile(this.microServiceConfiguration.getSetupEnvFile());
        this.lettoEnvFile = new LettoEnvFile(this.microServiceConfiguration.getLettoEnvFile());
        this.mysqlEnvFile = new MysqlEnvFile(this.microServiceConfiguration.getMysqlEnvFile());
    }

    public void saveConfiguration() {
        this.setupEnvFile.writeFile();
        this.lettoEnvFile.writeFile();
    }

    public MicroServiceConfiguration getMicroServiceConfiguration() {
        return this.microServiceConfiguration;
    }

    public LettoService getLettoService() {
        return this.lettoService;
    }

    public SetupEnvFile getSetupEnvFile() {
        return this.setupEnvFile;
    }

    public LettoEnvFile getLettoEnvFile() {
        return this.lettoEnvFile;
    }

    public MysqlEnvFile getMysqlEnvFile() {
        return this.mysqlEnvFile;
    }

    public HashMap<String, String> getSetupConfig() {
        return this.setupConfig;
    }
}

