/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.service.BackupService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LogFileService;
import at.letto.setupservice.service.WatchdogService;
import at.letto.tools.Cmd;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class CrontabConfiguration {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private LogFileService logFileService;
    @Autowired
    private WatchdogService watchdogService;
    private HashMap<CmdThread, Boolean> cmdFinished = new HashMap();

    @Scheduled(cron="0 0/30 * * * ?")
    public void every30Minutes() {
    }

    @Scheduled(cron="0/1 * * * * ?")
    public void everySecond() {
        this.dockerService.calcCpuUsage();
    }

    @Scheduled(cron="0 0/1 * * * ?")
    public void everyMinute() {
        int timeMinute;
        Date actualDate = new Date();
        this.dockerService.analyzeFirst();
        this.dockerService.checkMainSetupService();
        Calendar cal = Calendar.getInstance();
        cal.setTime(actualDate);
        int m = cal.get(12);
        if (this.dockerService.isDockerRunning()) {
            m += 5;
        }
        if (m % 10 == 0) {
            Thread thread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            thread.start();
        }
        if ((timeMinute = cal.get(12) + cal.get(11) * 60) == 1) {
            try {
                this.logFileService.archiveLogFiles();
            }
            catch (Exception exception) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        try {
            this.saveCmdLogFiles();
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            if (this.dockerService.getAdminLogfileWithDocker() == this.dockerService.isDockerRunning()) {
                this.logFileService.logSystemStatus();
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        this.watchdogService.watchdog();
        this.backupService.cronEveryMinute();
    }

    private boolean saveCmdThread(CmdThread cmdThread) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String filename = simpleDateFormat.format(cmdThread.getStartdate()) + "_" + (this.dockerService.isDockerRunning() ? "DOCKER_" : "HOST_") + Cmd.renameFile((String)cmdThread.getCommand()) + ".html";
            File file = new File(this.dockerService.getLogDirectoryPath() + "/setup/cmd");
            if (!file.exists()) {
                file.mkdirs();
            }
            file = new File(this.dockerService.getLogDirectoryPath() + "/setup/cmd/" + filename);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<h1>Background-Command</h1>command: " + cmdThread.getCommand() + "<br>\n");
            fileWriter.write("Status: <strong>" + cmdThread.getThreadStatus() + "</strong> " + cmdThread.getTimeInfoHTML() + "<br>\n");
            fileWriter.write("ID: " + cmdThread.getId() + "<br>\n<hr>\n");
            fileWriter.write(cmdThread.getHtmlOutput());
            fileWriter.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void saveCmdLogFiles() {
        HashMap<CmdThread, Boolean> finished = new HashMap<CmdThread, Boolean>();
        for (CmdThread cmdThread : this.cmdService.getThreads()) {
            if (this.cmdFinished.containsKey(cmdThread)) {
                if (((Boolean)this.cmdFinished.get(cmdThread)).booleanValue()) continue;
                this.saveCmdThread(cmdThread);
                if (!cmdThread.isFinished()) continue;
                finished.put(cmdThread, true);
                continue;
            }
            this.saveCmdThread(cmdThread);
            finished.put(cmdThread, cmdThread.isFinished());
        }
        this.cmdFinished = finished;
    }

    static /* synthetic */ DockerService access$000(CrontabConfiguration x0) {
        return x0.dockerService;
    }
}

