/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.beans;

import at.letto.setupservice.beans.FileEditBean;
import at.letto.setupservice.beans.FilePart;
import at.letto.setupservice.enumeration.FileEditMode;
import at.letto.tools.Cmd;
import java.io.File;
import java.io.FileInputStream;
import java.util.Base64;
import java.util.Vector;

public class FileEditBean {
    private int partLines = 50;
    private File file = null;
    private FileEditMode fileEditMode = FileEditMode.NULL;
    private String extension = "";
    private Vector<String> textLines = null;
    private Vector<FilePart> textParts = null;
    private String imageBase64 = null;
    private String info = "";
    private String helplink = "";
    private String backlink = "";
    private String oklink = "";
    private int part = 0;
    private int lines = 0;

    public void reloadFile() {
        this.loadFile(this.file);
    }

    public void loadFile(File f) {
        this.textLines = null;
        this.imageBase64 = null;
        this.textParts = null;
        this.lines = 0;
        this.part = 0;
        this.file = f;
        if (this.file.exists()) {
            try {
                String filename = this.file.getName();
                String[] np = filename.split("\\.");
                switch (this.extension = np[np.length - 1].toLowerCase()) {
                    case "html": 
                    case "htm": 
                    case "xhtml": 
                    case "xhtm": {
                        this.fileEditMode = FileEditMode.HTML;
                        break;
                    }
                    case "jpg": 
                    case "jpeg": 
                    case "png": 
                    case "gif": 
                    case "svg": {
                        this.fileEditMode = FileEditMode.IMG;
                        break;
                    }
                    case "env": 
                    case "txt": 
                    case "log": 
                    case "js": 
                    case "yml": 
                    case "yaml": 
                    case "sh": 
                    case "c": 
                    case "cpp": 
                    case "java": 
                    case "py": 
                    case "bat": 
                    case "conf": 
                    case "csv": {
                        this.fileEditMode = FileEditMode.TEXT;
                        break;
                    }
                    case "mp4": 
                    case "mp3": 
                    case "gz": 
                    case "zip": 
                    case "bin": 
                    case "exe": 
                    case "7z": 
                    case "rar": 
                    case "com": 
                    case "mov": 
                    case "ogg": 
                    case "wav": 
                    case "wave": 
                    case "doc": 
                    case "xls": 
                    case "xlsx": 
                    case "docx": {
                        this.fileEditMode = FileEditMode.BIN;
                        break;
                    }
                    default: {
                        this.fileEditMode = FileEditMode.NULL;
                    }
                }
                if (this.fileEditMode == FileEditMode.HTML || this.fileEditMode == FileEditMode.TEXT || this.fileEditMode == FileEditMode.NULL) {
                    try {
                        this.textLines = Cmd.readfile((File)this.file);
                        for (int i = 0; i < this.textLines.size(); ++i) {
                            String line = ((String)this.textLines.get(i)).replaceAll("\\r", "").replaceAll("\\t", "   ");
                            if (this.fileEditMode == FileEditMode.NULL && !line.matches("^[\\w\\d_ \\-\\.\\*\\+\\#\\'\\\"\\,;:\\!\\$\\%\\&/\\(\\)\\[\\]\\{\\}\u00df\\?\\\\\u00b0\\^\\|<>\u00b2\u00b3\u00b5\u00f6\u00e4\u00fc\u00d6\u00c4\u00dc]*$")) {
                                throw new Exception("Nicht unterst\u00fctzte Zeichen!!");
                            }
                            this.textLines.set(i, line);
                        }
                    }
                    catch (Exception ex) {
                        this.fileEditMode = FileEditMode.BIN;
                    }
                }
                if (this.fileEditMode == FileEditMode.BIN) {
                    this.textLines = new Vector();
                    this.textLines.add("Datei " + this.file.getName() + " ist eine Bin\u00e4rdatei und wird deshalb nicht geladen!");
                } else if (this.fileEditMode == FileEditMode.IMG) {
                    String ImgString = "";
                    try {
                        FileInputStream fis = new FileInputStream(this.file);
                        byte[] fileContent = new byte[(int)this.file.length()];
                        fis.read(fileContent);
                        byte[] ret = Base64.getEncoder().encode(fileContent);
                        this.imageBase64 = this.extension.equals("jpg") || this.extension.equals("jpeg") ? "data:image/jpg;base64, " : (this.extension.equals("png") ? "data:image/png;base64, " : (this.extension.equals("gif") ? "data:image/gif;base64, " : (this.extension.equals("svg") ? "data:image/svg;base64, " : "")));
                        this.imageBase64 = this.imageBase64 + new String(ret);
                        fis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.splitTextIntoParts();
            }
            catch (Exception exception) {}
        } else {
            this.fileEditMode = FileEditMode.NULL;
        }
    }

    public void splitTextIntoParts() {
        this.textParts = new Vector();
        if (this.textLines != null && this.textLines.size() > 0) {
            this.lines = this.textLines.size();
            StringBuilder sb = new StringBuilder();
            int n = 0;
            int startLineNumber = 1;
            boolean split = true;
            for (int i = 0; i < this.textLines.size(); ++i) {
                String line = (String)this.textLines.get(i);
                if (n >= this.partLines && split) {
                    if (i + this.partLines / 2 >= this.textLines.size()) {
                        split = false;
                    } else {
                        this.textParts.add(new FilePart(sb.toString(), startLineNumber, n));
                        n = 0;
                        startLineNumber = i + 1;
                        sb = new StringBuilder();
                    }
                }
                if (++n > 1) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            this.textParts.add(new FilePart(sb.toString(), startLineNumber, n));
            if (this.part >= this.textParts.size()) {
                this.part = this.textParts.size() - 1;
            }
        } else {
            this.textParts.add(new FilePart("", 0, 0));
        }
    }

    public void partsToText() {
        this.textLines = new Vector();
        for (FilePart part : this.textParts) {
            for (String line : part.getText().split("\\n")) {
                this.textLines.add(line);
            }
        }
    }

    public boolean saveFile() {
        switch (1.$SwitchMap$at$letto$setupservice$enumeration$FileEditMode[this.fileEditMode.ordinal()]) {
            case 1: 
            case 2: {
                try {
                    this.partsToText();
                    Cmd.writelnfile((Vector)this.textLines, (File)this.file);
                    return true;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        return false;
    }

    public boolean saveAndReload() {
        if (this.saveFile()) {
            this.reloadFile();
            return true;
        }
        return false;
    }

    public boolean img() {
        return this.fileEditMode == FileEditMode.IMG;
    }

    public boolean txt() {
        return this.fileEditMode == FileEditMode.TEXT;
    }

    public boolean htm() {
        return this.fileEditMode == FileEditMode.HTML;
    }

    public boolean bin() {
        return this.fileEditMode == FileEditMode.BIN;
    }

    public boolean notexists() {
        return this.fileEditMode == FileEditMode.NULL;
    }

    public String getFilename() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public String getPath() {
        if (this.file != null) {
            return this.file.getParentFile().getAbsolutePath().replaceAll("\\\\", "/").trim();
        }
        return "";
    }

    public int getParts() {
        if (this.fileEditMode == FileEditMode.TEXT || this.fileEditMode == FileEditMode.HTML) {
            return this.textParts.size();
        }
        return 0;
    }

    public FilePart getFilePart(int partnr) {
        if ((this.fileEditMode == FileEditMode.TEXT || this.fileEditMode == FileEditMode.HTML) && partnr < this.textParts.size() && partnr >= 0) {
            return (FilePart)this.textParts.get(partnr);
        }
        return new FilePart("", 0, 0);
    }

    public FilePart getFilePart() {
        return this.getFilePart(this.part);
    }

    public String getPartText() {
        String text = this.getFilePart(this.part).getText();
        return text;
    }

    public boolean setPart(int partnr, String part) {
        if (this.fileEditMode == FileEditMode.TEXT || this.fileEditMode == FileEditMode.HTML) {
            if (partnr < this.textParts.size() && partnr >= 0) {
                this.textParts.set(partnr, new FilePart(part, ((FilePart)this.textParts.get(partnr)).getStartLineNumber()));
                for (int i = partnr + 1; i < this.textParts.size(); ++i) {
                    ((FilePart)this.textParts.get(i)).setStartLineNumber(((FilePart)this.textParts.get((int)(i - 1))).startLineNumber + ((FilePart)this.textParts.get((int)(i - 1))).lines);
                }
                this.lines = ((FilePart)this.textParts.lastElement()).startLineNumber + ((FilePart)this.textParts.lastElement()).lines - 1;
                if (this.textParts.size() > 1 && part.split("\n").length < this.partLines / 2) {
                    return true;
                }
                if (part.split("\n").length > 2 * this.partLines) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void setPartText(String text) {
        boolean reorganize = this.setPart(this.part, text);
        if (reorganize) {
            this.partsToText();
            this.splitTextIntoParts();
        }
    }

    public void toLine(int line) {
        if (line < 1) {
            this.part = 0;
            return;
        }
        for (int i = this.textParts.size() - 1; i >= 0; --i) {
            if (line < ((FilePart)this.textParts.get((int)i)).startLineNumber) continue;
            this.part = i;
            return;
        }
    }

    public String getInhalt() {
        StringBuilder sb = new StringBuilder();
        for (FilePart part : this.textParts) {
            sb.append(part.getText());
            sb.append("\n");
        }
        return sb.toString();
    }

    public int getPartLines() {
        return this.partLines;
    }

    public File getFile() {
        return this.file;
    }

    public FileEditMode getFileEditMode() {
        return this.fileEditMode;
    }

    public String getExtension() {
        return this.extension;
    }

    public Vector<String> getTextLines() {
        return this.textLines;
    }

    public Vector<FilePart> getTextParts() {
        return this.textParts;
    }

    public String getImageBase64() {
        return this.imageBase64;
    }

    public String getInfo() {
        return this.info;
    }

    public String getHelplink() {
        return this.helplink;
    }

    public String getBacklink() {
        return this.backlink;
    }

    public String getOklink() {
        return this.oklink;
    }

    public int getPart() {
        return this.part;
    }

    public int getLines() {
        return this.lines;
    }

    public void setPartLines(int partLines) {
        this.partLines = partLines;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileEditMode(FileEditMode fileEditMode) {
        this.fileEditMode = fileEditMode;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setTextLines(Vector<String> textLines) {
        this.textLines = textLines;
    }

    public void setTextParts(Vector<FilePart> textParts) {
        this.textParts = textParts;
    }

    public void setImageBase64(String imageBase64) {
        this.imageBase64 = imageBase64;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setHelplink(String helplink) {
        this.helplink = helplink;
    }

    public void setBacklink(String backlink) {
        this.backlink = backlink;
    }

    public void setOklink(String oklink) {
        this.oklink = oklink;
    }

    public void setPart(int part) {
        this.part = part;
    }

    public void setLines(int lines) {
        this.lines = lines;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileEditBean)) {
            return false;
        }
        FileEditBean other = (FileEditBean)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPartLines() != other.getPartLines()) {
            return false;
        }
        if (this.getPart() != other.getPart()) {
            return false;
        }
        if (this.getLines() != other.getLines()) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        FileEditMode this$fileEditMode = this.getFileEditMode();
        FileEditMode other$fileEditMode = other.getFileEditMode();
        if (this$fileEditMode == null ? other$fileEditMode != null : !this$fileEditMode.equals(other$fileEditMode)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        Vector this$textLines = this.getTextLines();
        Vector other$textLines = other.getTextLines();
        if (this$textLines == null ? other$textLines != null : !((Object)this$textLines).equals(other$textLines)) {
            return false;
        }
        Vector this$textParts = this.getTextParts();
        Vector other$textParts = other.getTextParts();
        if (this$textParts == null ? other$textParts != null : !((Object)this$textParts).equals(other$textParts)) {
            return false;
        }
        String this$imageBase64 = this.getImageBase64();
        String other$imageBase64 = other.getImageBase64();
        if (this$imageBase64 == null ? other$imageBase64 != null : !this$imageBase64.equals(other$imageBase64)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        String this$helplink = this.getHelplink();
        String other$helplink = other.getHelplink();
        if (this$helplink == null ? other$helplink != null : !this$helplink.equals(other$helplink)) {
            return false;
        }
        String this$backlink = this.getBacklink();
        String other$backlink = other.getBacklink();
        if (this$backlink == null ? other$backlink != null : !this$backlink.equals(other$backlink)) {
            return false;
        }
        String this$oklink = this.getOklink();
        String other$oklink = other.getOklink();
        return !(this$oklink == null ? other$oklink != null : !this$oklink.equals(other$oklink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileEditBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartLines();
        result = result * 59 + this.getPart();
        result = result * 59 + this.getLines();
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        FileEditMode $fileEditMode = this.getFileEditMode();
        result = result * 59 + ($fileEditMode == null ? 43 : $fileEditMode.hashCode());
        String $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        Vector $textLines = this.getTextLines();
        result = result * 59 + ($textLines == null ? 43 : ((Object)$textLines).hashCode());
        Vector $textParts = this.getTextParts();
        result = result * 59 + ($textParts == null ? 43 : ((Object)$textParts).hashCode());
        String $imageBase64 = this.getImageBase64();
        result = result * 59 + ($imageBase64 == null ? 43 : $imageBase64.hashCode());
        String $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        String $helplink = this.getHelplink();
        result = result * 59 + ($helplink == null ? 43 : $helplink.hashCode());
        String $backlink = this.getBacklink();
        result = result * 59 + ($backlink == null ? 43 : $backlink.hashCode());
        String $oklink = this.getOklink();
        result = result * 59 + ($oklink == null ? 43 : $oklink.hashCode());
        return result;
    }

    public String toString() {
        return "FileEditBean(partLines=" + this.getPartLines() + ", file=" + this.getFile() + ", fileEditMode=" + this.getFileEditMode() + ", extension=" + this.getExtension() + ", textLines=" + this.getTextLines() + ", textParts=" + this.getTextParts() + ", imageBase64=" + this.getImageBase64() + ", info=" + this.getInfo() + ", helplink=" + this.getHelplink() + ", backlink=" + this.getBacklink() + ", oklink=" + this.getOklink() + ", part=" + this.getPart() + ", lines=" + this.getLines() + ")";
    }
}

