/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.utils.lti;

import at.letto.lti.model.dto.LoginInitiationDTO;
import at.letto.lti.model.lti.PlatformDeployment;
import at.letto.lti.model.lti.RSAKeyEntity;
import at.letto.lti.model.lti.RSAKeyId;
import at.letto.lti.service.LTIDataService;
import at.letto.lti.utils.oauth.OAuthUtils;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtiOidcUtils {
    static final Logger log = LoggerFactory.getLogger(LtiOidcUtils.class);

    public static String generateState(LTIDataService ltiDataService, PlatformDeployment platformDeployment, Map<String, String> authRequestMap, LoginInitiationDTO loginInitiationDTO) throws GeneralSecurityException, IOException {
        Date date = new Date();
        Optional rsaKeyEntityOptional = ltiDataService.getRepos().rsaKeys.findById((Object)new RSAKeyId("OWNKEY", Boolean.valueOf(true)));
        if (rsaKeyEntityOptional.isPresent()) {
            PrivateKey issPrivateKey = OAuthUtils.loadPrivateKey((String)((RSAKeyEntity)rsaKeyEntityOptional.get()).getPrivateKey());
            String state = Jwts.builder().setHeaderParam("kid", (Object)"OWNKEY").setIssuer("ltiStarter").setSubject(platformDeployment.getIss()).setAudience("Think about what goes here").setExpiration(DateUtils.addSeconds((Date)date, (int)3600)).setNotBefore(date).setIssuedAt(date).setId(authRequestMap.get("nonce")).claim("original_iss", (Object)loginInitiationDTO.getIss()).claim("loginHint", (Object)loginInitiationDTO.getLoginHint()).claim("ltiMessageHint", (Object)loginInitiationDTO.getLtiMessageHint()).claim("targetLinkUri", (Object)loginInitiationDTO.getTargetLinkUri()).claim("controller", (Object)"/oidc/login_initiations").signWith(SignatureAlgorithm.RS256, (Key)issPrivateKey).compact();
            log.debug("State: \n {} \n", (Object)state);
            return state;
        }
        throw new GeneralSecurityException("Error retrieving the state. No key was found.");
    }

    public static String generateState(LTIDataService ltiDataService, Map<String, String> authRequestMap, LoginInitiationDTO loginInitiationDTO, String clientIdValue, String deploymentIdValue) throws GeneralSecurityException, IOException {
        Date date = new Date();
        Optional rsaKeyEntityOptional = ltiDataService.getRepos().rsaKeys.findById((Object)new RSAKeyId("OWNKEY", Boolean.valueOf(true)));
        if (rsaKeyEntityOptional.isPresent()) {
            PrivateKey issPrivateKey = OAuthUtils.loadPrivateKey((String)((RSAKeyEntity)rsaKeyEntityOptional.get()).getPrivateKey());
            String state = Jwts.builder().setHeaderParam("kid", (Object)"OWNKEY").setHeaderParam("typ", (Object)"JWT").setIssuer("ltiStarter").setSubject(loginInitiationDTO.getIss()).setAudience(clientIdValue).setExpiration(DateUtils.addSeconds((Date)date, (int)3600)).setNotBefore(date).setIssuedAt(date).setId(authRequestMap.get("nonce")).claim("original_iss", (Object)loginInitiationDTO.getIss()).claim("loginHint", (Object)loginInitiationDTO.getLoginHint()).claim("ltiMessageHint", (Object)loginInitiationDTO.getLtiMessageHint()).claim("targetLinkUri", (Object)loginInitiationDTO.getTargetLinkUri()).claim("clientId", (Object)clientIdValue).claim("ltiDeploymentId", (Object)deploymentIdValue).claim("controller", (Object)"/oidc/login_initiations").signWith(SignatureAlgorithm.RS256, (Key)issPrivateKey).compact();
            log.debug("State: \n {} \n", (Object)state);
            return state;
        }
        throw new GeneralSecurityException("Error retrieving the state. No key was found.");
    }
}

