/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.service;

import at.letto.lti.dto.LTIplatformDTO;
import at.letto.lti.dto.LtiRsaKeyDTO;
import at.letto.lti.model.lti.ConfigEntity;
import at.letto.lti.model.lti.LtiContextEntity;
import at.letto.lti.model.lti.LtiLinkEntity;
import at.letto.lti.model.lti.LtiMembershipEntity;
import at.letto.lti.model.lti.LtiUserEntity;
import at.letto.lti.model.lti.PlatformDeployment;
import at.letto.lti.model.lti.RSAKeyEntity;
import at.letto.lti.model.lti.RSAKeyId;
import at.letto.lti.repository.AllRepositories;
import at.letto.lti.utils.lti.LTI3Request;
import java.util.List;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LTIDataService {
    static final Logger log = LoggerFactory.getLogger(LTIDataService.class);
    @Autowired
    AllRepositories repos;

    public AllRepositories getRepos() {
        return this.repos;
    }

    @Transactional
    public boolean loadLTIDataFromDB(LTI3Request lti) {
        assert (this.repos != null);
        lti.setLoaded(false);
        if (lti.getLtiDeploymentId() == null || lti.getAud() == null) {
            log.info("LTIload: No key to load lti.results for");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT k, c, l, m, u");
        sb.append(" FROM PlatformDeployment k LEFT JOIN k.contexts c ON c.contextKey = :context LEFT JOIN c.links l ON l.linkKey = :link LEFT JOIN c.memberships m LEFT JOIN m.user u ON u.userKey = :user ");
        sb.append(" WHERE k.clientId = :clientId AND k.deploymentId = :deploymentId AND k.iss = :iss AND (m IS NULL OR (m.context = c AND m.user = u))");
        String sql = sb.toString();
        Query q = this.repos.entityManager.createQuery(sql);
        q.setMaxResults(1);
        q.setParameter("clientId", (Object)lti.getAud());
        q.setParameter("deploymentId", (Object)lti.getLtiDeploymentId());
        q.setParameter("context", (Object)lti.getLtiContextId());
        q.setParameter("link", (Object)lti.getLtiLinkId());
        q.setParameter("user", (Object)lti.getSub());
        q.setParameter("iss", (Object)lti.getIss());
        List rows = q.getResultList();
        if (rows == null || rows.isEmpty()) {
            log.info("LTIload: No lti.results found for client_id: " + lti.getAud() + " and  deployment_id:" + lti.getLtiDeploymentId());
        } else {
            Object[] row = (Object[])rows.get(0);
            if (row.length > 0) {
                lti.setKey((PlatformDeployment)row[0]);
            }
            if (row.length > 1) {
                lti.setContext((LtiContextEntity)row[1]);
            }
            if (row.length > 2) {
                lti.setLink((LtiLinkEntity)row[2]);
            }
            if (row.length > 3) {
                lti.setMembership((LtiMembershipEntity)row[3]);
            }
            if (row.length > 4) {
                lti.setUser((LtiUserEntity)row[4]);
            }
            lti.checkCompleteLTIRequest();
            lti.setLoaded(true);
            log.info("LTIload: loaded data for clientid= " + lti.getAud() + " deploymentid=" + lti.getLtiDeploymentId() + " and context=" + lti.getLtiContextId() + ", complete=" + lti.isComplete());
        }
        return lti.isLoaded();
    }

    @Transactional
    public int updateLTIDataInDB(LTI3Request lti) {
        assert (this.repos != null) : "access to the repos is required";
        assert (lti.isLoaded()) : "Data must be loaded before it can be updated";
        assert (lti.getKey() != null) : "Key data must not be null to update data";
        this.repos.entityManager.merge((Object)lti.getKey());
        int inserts = 0;
        int updates = 0;
        if (lti.getContext() == null && lti.getLtiDeploymentId() != null) {
            LtiContextEntity newContext = new LtiContextEntity(lti.getLtiContextId(), lti.getKey(), lti.getLtiContextTitle(), null);
            lti.setContext((LtiContextEntity)this.repos.contexts.save((Object)newContext));
            ++inserts;
            log.info("LTIupdate: Inserted context id=" + lti.getLtiContextId());
        } else if (lti.getContext() != null) {
            this.repos.entityManager.merge((Object)lti.getContext());
            lti.setLtiContextId(lti.getContext().getContextKey());
            log.info("LTIupdate: Reconnected existing context id=" + lti.getLtiContextId());
        }
        if (lti.getLink() == null && lti.getLtiLinkId() != null) {
            LtiLinkEntity newLink = new LtiLinkEntity(lti.getLtiLinkId(), lti.getContext(), lti.getLtiLinkTitle(), null);
            lti.setLink((LtiLinkEntity)this.repos.links.save((Object)newLink));
            ++inserts;
            log.info("LTIupdate: Inserted link id=" + lti.getLtiLinkId());
        } else if (lti.getLink() != null) {
            this.repos.entityManager.merge((Object)lti.getLink());
            lti.setLtiLinkId(lti.getLink().getLinkKey());
            log.info("LTIupdate: Reconnected existing link id=" + lti.getLtiLinkId());
        }
        if (lti.getUser() == null && lti.getSub() != null) {
            LtiUserEntity newUser = new LtiUserEntity(lti.getSub(), null);
            newUser.setDisplayName(lti.getLtiName());
            newUser.setEmail(lti.getLtiEmail());
            lti.setUser((LtiUserEntity)this.repos.ltiUsers.save((Object)newUser));
            ++inserts;
            log.info("LTIupdate: Inserted user id=" + lti.getSub());
        } else if (lti.getUser() != null) {
            this.repos.entityManager.merge((Object)lti.getUser());
            lti.setSub(lti.getUser().getUserKey());
            lti.setLtiName(lti.getUser().getDisplayName());
            lti.setLtiEmail(lti.getUser().getEmail());
            log.info("LTIupdate: Reconnected existing user id=" + lti.getSub());
        }
        if (lti.getMembership() == null && lti.getContext() != null && lti.getUser() != null) {
            int roleNum = lti.makeUserRoleNum(lti.getLtiRoles());
            LtiMembershipEntity newMember = new LtiMembershipEntity(lti.getContext(), lti.getUser(), Integer.valueOf(roleNum));
            lti.setMembership((LtiMembershipEntity)this.repos.members.save((Object)newMember));
            ++inserts;
            log.info("LTIupdate: Inserted membership id=" + newMember.getMembershipId() + ", role=" + newMember.getRole() + ", user=" + lti.getSub() + ", context=" + lti.getLtiContextId());
        } else if (lti.getMembership() != null) {
            this.repos.entityManager.merge((Object)lti.getMembership());
            lti.setSub(lti.getUser().getUserKey());
            lti.setLtiContextId(lti.getContext().getContextKey());
            log.info("LTIupdate: Reconnected existing membership id=" + lti.getMembership().getMembershipId());
        }
        LtiContextEntity context = lti.getContext();
        if (lti.getLtiContextTitle() != null && context != null && !lti.getLtiContextTitle().equals(lti.getContext().getTitle())) {
            context.setTitle(lti.getLtiContextTitle());
            lti.setContext((LtiContextEntity)this.repos.contexts.save((Object)context));
            ++updates;
            log.info("LTIupdate: Updated context (id=" + lti.getContext().getContextId() + ") title=" + lti.getLtiContextTitle());
        }
        LtiLinkEntity link = lti.getLink();
        if (lti.getLtiLinkTitle() != null && link != null && !lti.getLtiLinkTitle().equals(link.getTitle())) {
            link.setTitle(lti.getLtiLinkTitle());
            lti.setLink((LtiLinkEntity)this.repos.links.save((Object)link));
            ++updates;
            log.info("LTIupdate: Updated link (id=" + lti.getLink().getLinkKey() + ") title=" + lti.getLtiLinkTitle());
        }
        boolean userChanged = false;
        LtiUserEntity user = lti.getUser();
        if (lti.getLtiName() != null && user != null && !lti.getLtiName().equals(user.getDisplayName())) {
            user.setDisplayName(lti.getLtiName());
            userChanged = true;
        }
        if (lti.getLtiEmail() != null && user != null && !lti.getLtiEmail().equals(user.getEmail())) {
            user.setEmail(lti.getLtiEmail());
            userChanged = true;
        }
        if (userChanged) {
            lti.setUser((LtiUserEntity)this.repos.ltiUsers.save((Object)user));
            ++updates;
            log.info("LTIupdate: Updated lti.user (id=" + lti.getUser().getUserKey() + ") name=" + lti.getLtiName() + ", email=" + lti.getLtiEmail());
        }
        LtiMembershipEntity membership = lti.getMembership();
        if (lti.getLtiRoles() != null && lti.getUserRoleNumber() != membership.getRole().intValue()) {
            membership.setRole(Integer.valueOf(lti.getUserRoleNumber()));
            lti.setMembership((LtiMembershipEntity)this.repos.members.save((Object)membership));
            ++updates;
            log.info("LTIupdate: Updated membership (id=" + lti.getMembership().getMembershipId() + ", user=" + lti.getSub() + ", context=" + lti.getLtiContextId() + ") roles=" + lti.getLtiRoles() + ", role=" + lti.getUserRoleNumber());
        }
        lti.checkCompleteLTIRequest(true);
        lti.setLoadingUpdates(inserts + updates);
        lti.setUpdated(true);
        log.info("LTIupdate: changes=" + lti.getLoadingUpdates() + ", inserts=" + inserts + ", updates=" + updates);
        return lti.getLoadingUpdates();
    }

    @Transactional
    public String getConfigValue(String key) {
        assert (this.repos != null) : "access to the repos is required";
        ConfigEntity config = this.repos.configs.findByName(key);
        if (config != null) {
            return config.getValue();
        }
        return null;
    }

    @Transactional
    public void setConfigValue(String key, String value) {
        assert (this.repos != null) : "access to the repos is required";
        ConfigEntity config = this.repos.configs.findByName(key);
        if (config != null) {
            config.setValue(value);
            this.repos.configs.saveAndFlush((Object)config);
        } else {
            this.repos.configs.saveAndFlush((Object)new ConfigEntity(key, value));
        }
    }

    @Transactional
    public void getRsaKeys(List<LtiRsaKeyDTO> dtokeys) {
        assert (this.repos != null) : "access to the repos is required";
        for (RSAKeyEntity key : this.repos.rsaKeys.findAll()) {
            LtiRsaKeyDTO dto = key.toDto();
            dtokeys.add(dto);
        }
    }

    @Transactional
    public LtiRsaKeyDTO setRsaKey(LtiRsaKeyDTO dtokey) {
        assert (this.repos != null) : "access to the repos is required";
        RSAKeyId keyId = new RSAKeyId(dtokey.getKid(), Boolean.valueOf(dtokey.isTool()));
        RSAKeyEntity key = this.repos.rsaKeys.findById((Object)keyId).orElse(null);
        if (key == null) {
            key = new RSAKeyEntity(dtokey.getKid(), Boolean.valueOf(dtokey.isTool()), dtokey.getPublicKey(), dtokey.getPrivateKey());
        } else {
            key.setPrivateKey("-----BEGIN PRIVATE KEY-----" + dtokey.getPrivateKey() + "-----END PRIVATE KEY-----");
            key.setPublicKey("-----BEGIN PUBLIC KEY-----" + dtokey.getPublicKey() + "-----END PUBLIC KEY-----");
        }
        this.repos.rsaKeys.saveAndFlush((Object)key);
        return key.toDto();
    }

    @Transactional
    public void removeRsaKey(LtiRsaKeyDTO dtokey) {
        assert (this.repos != null) : "access to the repos is required";
        RSAKeyId keyId = new RSAKeyId(dtokey.getKid(), Boolean.valueOf(dtokey.isTool()));
        RSAKeyEntity key = this.repos.rsaKeys.findById((Object)keyId).orElse(null);
        if (key == null) {
            return;
        }
        this.repos.rsaKeys.delete((Object)key);
        this.repos.rsaKeys.flush();
    }

    @Transactional
    public void getPlatforms(List<LTIplatformDTO> dtoPlatforms) {
        assert (this.repos != null) : "access to the repos is required";
        for (PlatformDeployment key : this.repos.platformDeploymentRepository.findAll()) {
            LTIplatformDTO dto = key.toDto();
            dtoPlatforms.add(dto);
        }
    }

    @Transactional
    public LTIplatformDTO setPlatform(LTIplatformDTO dtoPlatform) {
        assert (this.repos != null) : "access to the repos is required";
        PlatformDeployment platform = this.repos.platformDeploymentRepository.findById((Object)dtoPlatform.getKeyId()).orElse(null);
        if (platform == null) {
            platform = new PlatformDeployment();
        }
        platform.mapDto(dtoPlatform);
        this.repos.platformDeploymentRepository.saveAndFlush((Object)platform);
        return platform.toDto();
    }

    @Transactional
    public void removePlatform(LTIplatformDTO dtoPlatform) {
        assert (this.repos != null) : "access to the repos is required";
        PlatformDeployment platform = this.repos.platformDeploymentRepository.findById((Object)dtoPlatform.getKeyId()).orElse(null);
        if (platform == null) {
            return;
        }
        this.repos.platformDeploymentRepository.delete((Object)platform);
        this.repos.platformDeploymentRepository.flush();
    }
}

