/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.model.lti;

import at.letto.lti.model.lti.BaseEntity;
import at.letto.lti.model.lti.LtiContextEntity;
import at.letto.lti.model.lti.LtiUserEntity;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="lti_membership")
public class LtiMembershipEntity
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="membership_id", nullable=false, insertable=true, updatable=true)
    private long membershipId;
    @Basic
    @Column(name="role", nullable=true, insertable=true, updatable=true)
    private Integer role;
    @Basic
    @Column(name="role_override", nullable=true, insertable=true, updatable=true)
    private Integer roleOverride;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="context_id")
    private LtiContextEntity context;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="user_id")
    private LtiUserEntity user;

    protected LtiMembershipEntity() {
    }

    public LtiMembershipEntity(LtiContextEntity context, LtiUserEntity user, Integer role) {
        if (user == null) {
            throw new AssertionError();
        }
        if (context == null) {
            throw new AssertionError();
        }
        this.user = user;
        this.context = context;
        this.role = role;
    }

    public long getMembershipId() {
        return this.membershipId;
    }

    public void setMembershipId(long membershipId) {
        this.membershipId = membershipId;
    }

    public Integer getRole() {
        return this.role;
    }

    public void setRole(Integer role) {
        this.role = role;
    }

    public Integer getRoleOverride() {
        return this.roleOverride;
    }

    public void setRoleOverride(Integer roleOverride) {
        this.roleOverride = roleOverride;
    }

    public LtiContextEntity getContext() {
        return this.context;
    }

    public void setContext(LtiContextEntity context) {
        this.context = context;
    }

    public LtiUserEntity getUser() {
        return this.user;
    }

    public void setUser(LtiUserEntity user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtiMembershipEntity that = (LtiMembershipEntity)o;
        if (this.context.getContextId() != that.context.getContextId()) {
            return false;
        }
        if (this.membershipId != that.membershipId) {
            return false;
        }
        if (this.user.getUserId() != that.user.getUserId()) {
            return false;
        }
        return this.role != null ? this.role.equals(that.role) : that.role == null;
    }

    public int hashCode() {
        int result = (int)this.membershipId;
        result = 31 * result + (int)this.context.getContextId();
        result = 31 * result + (int)this.user.getUserId();
        result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
        return result;
    }
}

