/*
 * Decompiled with CFR 0.152.
 */
package at.letto.pluginservice.security;

import at.letto.pluginservice.config.MicroServiceConfiguration;
import at.letto.security.JwtAuthentication;
import at.letto.security.LettoToken;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationTokenFilter
extends OncePerRequestFilter {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String requestHeader = request.getHeader("authorization");
        if (requestHeader != null && requestHeader.startsWith("Bearer ")) {
            String authToken = requestHeader.substring(7);
            LettoToken lettoToken = new LettoToken(authToken, this.microServiceConfiguration.getJwtSecret());
            JwtAuthentication authentication = new JwtAuthentication(lettoToken);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

