/*
 * Decompiled with CFR 0.152.
 */
package at.letto.mailservice.config;

import at.letto.mailservice.config.MicroServiceConfiguration;
import org.apache.catalina.connector.Connector;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
public class TomcatConfiguration {
    private MicroServiceConfiguration microServiceConfiguration;
    private int httpPort;
    private int httpsPort;
    private int ajpPort;

    public TomcatConfiguration(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.httpPort = this.microServiceConfiguration.getMailHttpPort();
        this.httpsPort = this.microServiceConfiguration.getMailHttpsPort();
        this.ajpPort = this.microServiceConfiguration.getMailAjpPort();
    }

    @Bean
    public ServletWebServerFactory servletHTTPContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.microServiceConfiguration.createAjpConnector(this.ajpPort)});
        tomcat.addAdditionalTomcatConnectors(new Connector[]{this.microServiceConfiguration.createSslConnector(this.httpsPort)});
        return tomcat;
    }

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:locale/messages");
        messageSource.setCacheSeconds(10);
        return messageSource;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getAjpPort() {
        return this.ajpPort;
    }

    static /* synthetic */ int access$000(TomcatConfiguration x0) {
        return x0.httpPort;
    }
}

