/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.service;

import at.letto.loginservice.config.LoggingConfiguration;
import at.letto.loginservice.config.MicroServiceConfiguration;
import at.letto.loginservice.config.TomcatConfiguration;
import at.letto.service.image.ImageServiceDto;
import at.letto.service.rest.RestImageService;
import at.letto.service.rest.RestLettoDataService;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LettoService {
    private Logger logger = LoggerFactory.getLogger(LettoService.class);
    private TomcatConfiguration tomcatConfiguration;
    private MicroServiceConfiguration microServiceConfiguration;
    private LoggingConfiguration loggingConfiguration;
    private RestImageService imageService = null;
    private Hashtable<Integer, RestLettoDataService> dataServiceHashtable = null;

    public LettoService(TomcatConfiguration tomcatConfiguration, MicroServiceConfiguration microServiceConfiguration, LoggingConfiguration loggingConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.tomcatConfiguration = tomcatConfiguration;
        this.loggingConfiguration = loggingConfiguration;
        this.dataServiceHashtable = new Hashtable();
        this.loadLettoDataService(microServiceConfiguration.getSchuleStandardIdSchuleLizenz(), microServiceConfiguration.getSchuleStandardSchulename(), microServiceConfiguration.getSchuleStandardLettoDataUser(), microServiceConfiguration.getSchuleStandardLettoDataPassword(), microServiceConfiguration.getSchuleStandardLettoDataUri());
        this.getImageService();
    }

    public synchronized RestImageService getImageService() {
        if (this.imageService == null) {
            try {
                this.imageService = new RestImageService(this.microServiceConfiguration.getImageServiceUri(), this.microServiceConfiguration.getImageServiceUser(), this.microServiceConfiguration.getImageServicePassword(), ImageServiceDto.SERVICEMODE.parse((String)this.microServiceConfiguration.getImageServiceMode()), this.microServiceConfiguration.getImageServiceTempDir());
            }
            catch (Exception ex) {
                this.logger.error("Imageservice kann nicht geladen werden von " + this.microServiceConfiguration.getImageServiceUri());
            }
        }
        return this.imageService;
    }

    public void loadLettoDataService(String idSchule, String schulname, String username, String password, String uri) {
        try {
            int id = Integer.parseInt(idSchule);
            RestLettoDataService dataService = new RestLettoDataService(uri, username, password, id, schulname);
            this.dataServiceHashtable.put(id, dataService);
        }
        catch (Exception ex) {
            this.logger.error("LettoData Service f\u00fcr die Schule " + schulname + " kann nicht geladen werden von " + uri);
        }
    }

    public List<RestLettoDataService> getLettoDataServices() {
        ArrayList<RestLettoDataService> ret = new ArrayList<RestLettoDataService>();
        for (RestLettoDataService s : this.dataServiceHashtable.values()) {
            ret.add(s);
        }
        return ret;
    }

    public RestLettoDataService getLettoDataService(Integer idSchule) {
        if (idSchule != null && this.dataServiceHashtable.containsKey(idSchule)) {
            return (RestLettoDataService)this.dataServiceHashtable.get(idSchule);
        }
        return null;
    }
}

