/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.security;

import at.letto.loginservice.security.JwtTokenService;
import at.letto.security.JwtAuthenticatedProfile;
import at.letto.security.JwtAuthentication;
import at.letto.security.JwtAuthenticationException;
import at.letto.security.LettoToken;
import io.jsonwebtoken.JwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class JwtAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationProvider.class);
    private final JwtTokenService jwtService;

    public JwtAuthenticationProvider() {
        this(null);
    }

    @Autowired
    public JwtAuthenticationProvider(JwtTokenService jwtService) {
        this.jwtService = jwtService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            String token = (String)authentication.getCredentials();
            LettoToken lettoToken = this.jwtService.toLettoToken(token);
            String username = lettoToken.getUsername();
            return (Authentication)lettoToken.validateToken().map(aBoolean -> new JwtAuthenticatedProfile(username)).orElseThrow(() -> new JwtAuthenticationException("JWT Token validation failed"));
        }
        catch (JwtException ex) {
            log.error(String.format("Invalid JWT Token: %s", ex.getMessage()));
            throw new JwtAuthenticationException("Failed to verify token");
        }
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthentication.class.equals(authentication);
    }
}

