/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.controller;

import at.letto.loginservice.config.TomcatConfiguration;
import at.letto.loginservice.model.LoginModel;
import at.letto.loginservice.service.AuthenticationService;
import at.letto.security.LettoToken;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class MainHttpController {
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private AuthenticationService authenticationService;

    private String getusername() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        try {
            return ((User)auth.getPrincipal()).getUsername();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean hasRole(String role) {
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            for (GrantedAuthority a : auth.getAuthorities()) {
                if (!a.toString().equals("ROLE_" + role.toUpperCase())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isUser() {
        return this.hasRole("user");
    }

    public boolean isGast() {
        return this.hasRole("gast");
    }

    public boolean isAdmin() {
        return this.hasRole("admin");
    }

    public boolean isLetto() {
        return this.hasRole("letto");
    }

    @RequestMapping(value={""})
    public String indexForm(Model model) {
        return "redirect:/login/open/dashboard";
    }

    @RequestMapping(value={"/login/open/home"})
    public String home(Model model) {
        model.addAttribute("username", (Object)this.getusername());
        return "home";
    }

    @RequestMapping(value={"/login/auth/login"})
    public String login(@ModelAttribute LoginModel loginModel, Model model) {
        model.addAttribute("loginModel", (Object)loginModel);
        model.addAttribute("username", (Object)this.getusername());
        return "loginletto";
    }

    @RequestMapping(value={"/login/open/loginletto"})
    public ResponseEntity<Object> loginletto(@ModelAttribute LoginModel loginModel) {
        HttpHeaders httpHeaders;
        block5: {
            httpHeaders = new HttpHeaders();
            try {
                URI uri = new URI("/login/auth/login");
                httpHeaders.setLocation(uri);
                if (loginModel == null || loginModel.getName().length() <= 0 || loginModel.getPasswort().length() <= 0) break block5;
                try {
                    LettoToken lettoToken = this.authenticationService.generateLettoToken(loginModel.getName(), loginModel.getPasswort(), null);
                    if (lettoToken != null) {
                        String redirectUri = this.authenticationService.generateTempTokenUriShort(lettoToken);
                        uri = new URI(redirectUri);
                        httpHeaders.setLocation(uri);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception uri) {
                // empty catch block
            }
        }
        ResponseEntity response = new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.SEE_OTHER);
        return response;
    }

    @RequestMapping(value={"/login/open/logincheck"})
    public String logincheckForm(@ModelAttribute LoginModel loginModel, Model model) {
        return "login";
    }

    @RequestMapping(value={"/login/open/logoutletto"})
    public String logout(Model model) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String username = "World";
        try {
            username = ((User)auth.getPrincipal()).getUsername();
        }
        catch (Exception exception) {
            // empty catch block
        }
        model.addAttribute("message", (Object)"Hallo Welt!");
        model.addAttribute("user", (Object)username);
        model.addAttribute("tasks", (Object)this);
        model.addAttribute("loginModel", (Object)new LoginModel());
        return "lettologin";
    }

    @RequestMapping(value={"/login/open/dashboard"})
    public String dashboard(Model model) {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            LettoToken lettoToken = (LettoToken)authentication.getDetails();
            model.addAttribute("username", (Object)lettoToken.getUsername());
            model.addAttribute("email", (Object)lettoToken.getEmail());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "dashboard";
    }

    public TomcatConfiguration getTomcatConfiguration() {
        return this.tomcatConfiguration;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setTomcatConfiguration(TomcatConfiguration tomcatConfiguration) {
        this.tomcatConfiguration = tomcatConfiguration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }
}

