/*
 * Decompiled with CFR 0.152.
 */
package at.letto.loginservice.controller;

import at.letto.basespringboot.exceptions.UserNotFoundException;
import at.letto.loginservice.service.AuthenticationService;
import at.letto.service.login.AuthenticationRequest;
import at.letto.service.login.JWTTokenResponse;
import at.letto.service.login.TempTokenRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JWTLoginController {
    private AuthenticationService authenticationService;

    public JWTLoginController(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value={"/login/api/jwtlogin"})
    public ResponseEntity<JWTTokenResponse> jwtLogin(@RequestBody AuthenticationRequest request) {
        return new ResponseEntity((Object)this.authenticationService.generateJWTToken(request.getUsername(), request.getPassword(), request.toIdSchule()), HttpStatus.OK);
    }

    @PostMapping(value={"/login/api/jwtrefresh"})
    public ResponseEntity<JWTTokenResponse> jwtLogin(@RequestBody String token) {
        return new ResponseEntity((Object)this.authenticationService.refreshJWTToken(token), HttpStatus.OK);
    }

    @PostMapping(value={"/login/api/jwttemptoken"})
    public ResponseEntity<JWTTokenResponse> jwtTempToken(@RequestBody TempTokenRequest request) {
        return new ResponseEntity((Object)this.authenticationService.generateJWTTokenFromTempToken(request.getTempToken(), request.getSecret()), HttpStatus.OK);
    }

    @ExceptionHandler(value={UserNotFoundException.class})
    public ResponseEntity<String> handleEntityNotFoundException(UserNotFoundException ex) {
        return new ResponseEntity((Object)ex.getMessage(), HttpStatus.NOT_FOUND);
    }
}

