/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.StartupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.model.CmdThread;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.UpdateService;
import java.io.File;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DockerService {
    @Autowired
    StartupConfiguration startupConfiguration;
    @Autowired
    DockerConfiguration dockerConfiguration;
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    AnalyzeService analyzeService;
    @Autowired
    CmdService cmdService;
    @Autowired
    UpdateService updateService;

    public String createPath() {
        String ret = "";
        try {
            Vector paths = this.dockerConfiguration.getSetupPaths();
            for (String p : paths) {
                File f;
                if (p == null || (f = new File(p)).isDirectory()) continue;
                if (f.isFile()) {
                    f.delete();
                }
                f.mkdirs();
                if (!f.isDirectory()) {
                    ret = ret + "cannot create " + f.getAbsolutePath() + " ! ";
                }
                if (!this.analyzeService.isLinux()) continue;
                CmdThread cmdThread = this.cmdService.cmdScriptForeground(4000L, new String[]{"chown letto -R " + p, "chmod 755 -R " + p});
                this.cmdService.removeThread(cmdThread);
            }
            this.dockerConfiguration.saveConfiguration();
        }
        catch (Exception ex) {
            ret = ret + "cannot create LeTTo-Docker-directories ! ";
        }
        return ret;
    }

    public void saveAndReloadConfiguration() {
        this.dockerConfiguration.saveConfiguration();
        this.dockerConfiguration.loadConfiguration();
    }

    public File getSetupFile() {
        return this.dockerConfiguration.getSetupFile();
    }
}

