/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.dto.ThreadStatus;
import at.letto.setupservice.model.CmdThread;
import at.letto.setupservice.service.AnalyzeService;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class CmdService {
    @Autowired
    AnalyzeService analyzeService;
    private Vector<CmdThread> threads = new Vector();
    private String charset = null;

    public CmdThread cmdScriptBackground(String backlink, String homedir, String ... cmd) {
        CmdThread cmdThread = this.analyzeService.isWindows() ? this.createThread(homedir, CmdThread.CmdMode.BATCH, cmd).backlink(backlink) : this.createThread(homedir, CmdThread.CmdMode.BASH, cmd).backlink(backlink);
        return cmdThread;
    }

    public CmdThread cmdBackground(String backlink, String homedir, String ... cmd) {
        CmdThread cmdThread = this.analyzeService.isWindows() ? this.createThread(homedir, CmdThread.CmdMode.CMD, cmd).backlink(backlink) : this.createThread(homedir, CmdThread.CmdMode.NORMAL, cmd).backlink(backlink);
        return cmdThread;
    }

    public CmdThread cmdForeground(long timeoutms, String ... cmd) {
        if (this.analyzeService.isWindows()) {
            return this.cmdForeground(this.analyzeService.getRootPath(), timeoutms, CmdThread.CmdMode.CMD, cmd);
        }
        return this.cmdForeground(this.analyzeService.getRootPath(), timeoutms, CmdThread.CmdMode.NORMAL, cmd);
    }

    public CmdThread cmdScriptForeground(long timeoutms, String ... cmd) {
        if (this.analyzeService.isWindows()) {
            return this.cmdForeground(this.analyzeService.getRootPath(), timeoutms, CmdThread.CmdMode.BATCH, cmd);
        }
        return this.cmdForeground(this.analyzeService.getRootPath(), timeoutms, CmdThread.CmdMode.BASH, cmd);
    }

    public CmdThread cmdForeground(String homedir, long timeoutms, CmdThread.CmdMode cmdMode, String ... cmd) {
        CmdThread cmdThread = CmdThread.createThread((String)homedir, (String)this.analyzeService.getCmdCharset(), (CmdThread.CmdMode)cmdMode, (String[])cmd);
        this.threads.add(cmdThread);
        long t = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() - t < timeoutms && cmdThread.getThreadStatus() == ThreadStatus.RUNNING);
        if (!cmdThread.isFinished()) {
            cmdThread.stop();
        }
        return cmdThread;
    }

    public String opencmd(Model model, String backlink, CmdThread cmdThread) {
        cmdThread.backlink(backlink);
        model.addAttribute("cmdThread", (Object)cmdThread);
        model.addAttribute("threads", (Object)this.threads);
        return "cmdoutput";
    }

    private CmdThread createThread(String homedir, CmdThread.CmdMode cmdMode, String ... cmd) {
        CmdThread cmdThread = CmdThread.createThread((String)homedir, (String)this.analyzeService.getCmdCharset(), (CmdThread.CmdMode)cmdMode, (String[])cmd);
        this.threads.add(cmdThread);
        long t = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() - t < 1000L && cmdThread.getThreadStatus() == ThreadStatus.RUNNING);
        return cmdThread;
    }

    public CmdThread getThread(long id) {
        if (id < 1L) {
            return null;
        }
        try {
            for (int i = 0; i < this.threads.size(); ++i) {
                CmdThread t = (CmdThread)this.threads.get(i);
                if (t.getId() != id) continue;
                return t;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public CmdThread getThread(String id) {
        if (id == null || id.length() < 1) {
            return null;
        }
        try {
            for (int i = 0; i < this.threads.size(); ++i) {
                CmdThread t = (CmdThread)this.threads.get(i);
                if (!(t.getId() + "").equals(id)) continue;
                return t;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void removeThread(CmdThread cmdThread) {
        try {
            cmdThread.stop();
            this.threads.remove(cmdThread);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String htmlStatusInfo() {
        int running = 0;
        int finished = 0;
        for (int i = 0; i < this.threads.size(); ++i) {
            CmdThread t = (CmdThread)this.threads.get(i);
            if (t.isFinished()) {
                ++finished;
                continue;
            }
            ++running;
        }
        if (running + finished == 0) {
            return "";
        }
        String ret = "";
        if (running > 0) {
            ret = "<span style=\"color:red;\">" + running + "</span> tasks running - ";
        }
        ret = ret + finished + " tasks finished";
        return ret;
    }

    public AnalyzeService getAnalyzeService() {
        return this.analyzeService;
    }

    public Vector<CmdThread> getThreads() {
        return this.threads;
    }

    public String getCharset() {
        return this.charset;
    }
}

