/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.model;

import at.letto.setupservice.dto.ThreadStatus;
import at.letto.setupservice.model.CmdThread;
import at.letto.tools.Datum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unbescape.html.HtmlEscape;

public class CmdThread
implements Runnable {
    private final CmdMode cmdMode;
    private static long id_counter = 0L;
    private final long id;
    private final String homedir;
    private final String[] cmd;
    private final String command;
    private String charset;
    private final Thread thread;
    private final long starttime;
    private final Date startdate;
    private long stoptime = 0L;
    private ThreadStatus threadStatus = ThreadStatus.NEW;
    private Throwable error = null;
    private Vector<Vector<String>> out = new Vector();
    private Vector<Vector<String>> err = new Vector();
    private Vector<String> htmlOutput = new Vector();
    private String backlink = "";
    private File batchfile;

    private CmdThread(String homedir, String charset, CmdMode cmdMode, String ... cmd) {
        this.id = ++id_counter;
        this.homedir = homedir;
        Vector<String> cv = new Vector<String>();
        for (String c : cmd) {
            c = c.replaceAll("\\r", "").trim();
            for (String cs : c.split("\\n")) {
                if ((cs = cs.trim()).startsWith("#") || cs.startsWith("/*") || cs.startsWith("//")) continue;
                cv.add(cs);
            }
        }
        String[] nc = new String[cv.size()];
        for (int i = 0; i < cv.size(); ++i) {
            nc[i] = (String)cv.get(i);
        }
        this.cmd = nc;
        this.charset = charset;
        this.cmdMode = cmdMode;
        String command1 = "";
        if (this.cmd.length == 1) {
            command1 = this.cmd[0];
        } else if (this.cmd.length < 1) {
            command1 = "";
        } else {
            command1 = this.cmd[0];
            for (int i = 1; i < this.cmd.length; ++i) {
                command1 = command1 + ", " + this.cmd[i];
            }
        }
        this.command = command1;
        this.thread = new Thread((Runnable)this);
        this.starttime = System.currentTimeMillis();
        this.startdate = new Date();
        this.thread.start();
    }

    public static CmdThread createThread(String homedir, String charset, String ... cmd) {
        return new CmdThread(homedir, charset, CmdMode.NORMAL, cmd);
    }

    public static CmdThread createThread(String homedir, String charset, CmdMode cmdMode, String ... cmd) {
        return new CmdThread(homedir, charset, cmdMode, cmd);
    }

    public CmdThread backlink(String backlink) {
        this.backlink = backlink;
        return this;
    }

    private void htmlCmd(String cmd) {
        this.htmlOutput.add("<div style=\"color:blue;\">" + HtmlEscape.escapeHtml5((String)cmd) + "</div>");
    }

    private void htmlOut(String cmd) {
        this.htmlOutput.add("<div style=\"color:black;\">" + HtmlEscape.escapeHtml5((String)cmd) + "</div>");
    }

    private void htmlErr(String cmd) {
        this.htmlOutput.add("<div style=\"color:red;\">" + HtmlEscape.escapeHtml5((String)cmd) + "</div>");
    }

    @Override
    public void run() {
        this.threadStatus = ThreadStatus.RUNNING;
        File batchfile = null;
        try {
            if (this.cmdMode == CmdMode.BATCH || this.cmdMode == CmdMode.BASH || this.cmdMode == CmdMode.SH) {
                int i = 0;
                do {
                    String filename = ("b" + Math.random() * 1.0E12).replaceAll("\\.", "").replaceAll("E", "");
                    filename = this.cmdMode == CmdMode.BATCH ? filename + ".bat" : filename + ".sh";
                    batchfile = new File(filename);
                    if (batchfile.exists()) {
                        batchfile = null;
                        continue;
                    }
                    batchfile.createNewFile();
                } while (++i < 1000 && batchfile == null);
                if (!batchfile.exists()) {
                    batchfile = null;
                }
                if (batchfile == null) {
                    throw new RuntimeException("Fehler, Batchdatei kann nicht erstellt werden!!");
                }
                FileWriter fileWriter = new FileWriter(batchfile);
                if (this.cmdMode == CmdMode.BASH) {
                    fileWriter.write("#!/bin/bash -e\n");
                }
                if (this.cmdMode == CmdMode.SH) {
                    fileWriter.write("#!/bin/sh -e\n");
                }
                if (this.cmdMode == CmdMode.BATCH) {
                    fileWriter.write("@echo off\n");
                }
                for (i = 0; i < this.cmd.length; ++i) {
                    if (this.cmdMode == CmdMode.BATCH) {
                        fileWriter.write("echo XXX" + i + ":" + this.cmd[i] + "\n");
                    } else {
                        fileWriter.write("echo \"XXX" + i + ":" + this.cmd[i].replaceAll("\"", "\\\\\"") + "\"\n");
                    }
                    fileWriter.write(this.cmd[i] + "\n");
                }
                fileWriter.close();
                batchfile.setExecutable(true);
                String c = batchfile.getAbsolutePath();
                this.htmlCmd(c);
                Vector vout = new Vector();
                Vector verr = new Vector();
                this.out.add(vout);
                this.err.add(verr);
                this.systemcall(c, this.charset, vout);
            } else {
                for (int i = 0; i < this.cmd.length; ++i) {
                    String c = this.cmd[i];
                    this.htmlCmd(c);
                    Vector vout = new Vector();
                    Vector verr = new Vector();
                    this.out.add(vout);
                    this.err.add(verr);
                    this.systemcall(c, this.charset, vout, verr);
                }
            }
            this.threadStatus = ThreadStatus.FINISHED;
        }
        catch (Exception ex) {
            this.threadStatus = ThreadStatus.ERROR;
            this.error = ex;
        }
        catch (Error err) {
            this.threadStatus = ThreadStatus.ERROR;
            this.error = err;
        }
        try {
            if (batchfile != null && batchfile.exists()) {
                batchfile.delete();
            }
            batchfile = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stoptime = System.currentTimeMillis();
    }

    public String getHtmlOutput() {
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < this.htmlOutput.size(); ++i) {
                sb.append((String)this.htmlOutput.get(i));
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        String s = sb.toString();
        return s;
    }

    public void systemcall(String cmd, String charset, Vector<String> out) {
        this.systemcall(cmd, charset, out, null);
    }

    public void systemcall(String cmd, String charset, Vector<String> out, Vector<String> err) {
        Process p = null;
        try {
            String line;
            File hd;
            String acmd = "";
            String h = cmd;
            boolean mode = false;
            Vector<String> cv = new Vector<String>();
            if (this.cmdMode == CmdMode.CMD || this.cmdMode == CmdMode.BATCH) {
                cv.add("cmd");
                cv.add("/c");
            }
            do {
                int pos = h.length();
                int c = 97;
                int f = h.indexOf("\"");
                if (f > -1 && f < pos) {
                    pos = f;
                    c = 34;
                }
                if ((f = h.indexOf(" ")) > -1 && f < pos) {
                    pos = f;
                    c = 32;
                }
                if (c != 97) {
                    acmd = acmd + h.substring(0, pos);
                    h = h.substring(pos);
                }
                if (c == 34) {
                    mode = !mode;
                    h = h.substring(1);
                    continue;
                }
                if (c == 32) {
                    if (mode) {
                        acmd = acmd + " ";
                    } else {
                        if (acmd.length() > 0) {
                            cv.add(acmd);
                        }
                        acmd = "";
                    }
                    h = h.substring(1);
                    continue;
                }
                acmd = acmd + h;
                h = "";
            } while (h.length() > 0);
            if (acmd.length() > 0) {
                cv.add(acmd);
            }
            String[] cmdlst = new String[cv.size()];
            for (int j = 0; j < cv.size(); ++j) {
                cmdlst[j] = (String)cv.get(j);
            }
            ProcessBuilder pb = new ProcessBuilder(cmdlst);
            if (err == null) {
                pb.redirectErrorStream(true);
            }
            if ((hd = new File(this.homedir)).exists()) {
                pb = pb.directory(hd);
            }
            p = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), charset));
            BufferedReader error = null;
            error = new BufferedReader(new InputStreamReader(p.getErrorStream(), charset));
            Pattern pattern = Pattern.compile("^XXX(\\d+):(.+)$");
            while ((line = reader.readLine()) != null) {
                Matcher m = pattern.matcher(line);
                if (m.find()) {
                    this.htmlCmd(m.group(2));
                    continue;
                }
                out.add(line);
                this.htmlOut(line);
            }
            if (err != null && error != null) {
                String line1;
                while ((line1 = error.readLine()) != null) {
                    err.add(line1);
                    this.htmlErr(line1);
                }
            }
            p.destroyForcibly();
        }
        catch (IOException e1) {
            String e = cmd + " kann nicht gestartet werden!";
            if (err == null) {
                out.add(e);
                this.htmlOut(e);
            }
            err.add(e);
            this.htmlErr(e);
        }
    }

    public void stop() {
        if (this.threadStatus == ThreadStatus.RUNNING) {
            try {
                this.thread.stop();
                if (this.thread.isAlive()) {
                    this.thread.destroy();
                }
            }
            catch (Exception ex) {
                System.out.println("Prozess konnte nicht gestoppt werden!");
            }
            catch (Error error) {
                System.out.println("Error: Prozess konnte nicht gestoppt werden!");
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.batchfile != null && this.batchfile.exists()) {
                    this.batchfile.delete();
                }
                this.batchfile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.threadStatus = ThreadStatus.STOPPED;
        }
    }

    public String getTimeInfoHTML() {
        String ret = "<span style=\"color:orange\">" + Datum.formatDateTime((Date)this.startdate) + "</span> - <span style=\"color:blue\">";
        ret = this.isFinished() ? ret + (double)(this.stoptime - this.starttime) / 1000.0 : ret + (double)(System.currentTimeMillis() - this.starttime) / 1000.0;
        ret = ret + " s </span>";
        return ret;
    }

    public boolean isFinished() {
        switch (1.$SwitchMap$at$letto$setupservice$dto$ThreadStatus[this.threadStatus.ordinal()]) {
            default: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
        }
        return true;
    }

    public CmdThread(CmdMode cmdMode, long id, String homedir, String[] cmd, String command, String charset, Thread thread, long starttime, Date startdate, long stoptime, ThreadStatus threadStatus, Throwable error, Vector<Vector<String>> out, Vector<Vector<String>> err, Vector<String> htmlOutput, String backlink, File batchfile) {
        this.cmdMode = cmdMode;
        this.id = id;
        this.homedir = homedir;
        this.cmd = cmd;
        this.command = command;
        this.charset = charset;
        this.thread = thread;
        this.starttime = starttime;
        this.startdate = startdate;
        this.stoptime = stoptime;
        this.threadStatus = threadStatus;
        this.error = error;
        this.out = out;
        this.err = err;
        this.htmlOutput = htmlOutput;
        this.backlink = backlink;
        this.batchfile = batchfile;
    }

    public CmdMode getCmdMode() {
        return this.cmdMode;
    }

    public long getId() {
        return this.id;
    }

    public String getHomedir() {
        return this.homedir;
    }

    public String[] getCmd() {
        return this.cmd;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCharset() {
        return this.charset;
    }

    public Thread getThread() {
        return this.thread;
    }

    public long getStarttime() {
        return this.starttime;
    }

    public Date getStartdate() {
        return this.startdate;
    }

    public long getStoptime() {
        return this.stoptime;
    }

    public ThreadStatus getThreadStatus() {
        return this.threadStatus;
    }

    public Throwable getError() {
        return this.error;
    }

    public Vector<Vector<String>> getOut() {
        return this.out;
    }

    public Vector<Vector<String>> getErr() {
        return this.err;
    }

    public String getBacklink() {
        return this.backlink;
    }

    public File getBatchfile() {
        return this.batchfile;
    }
}

