/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.setupservice.component.LettoSetupComponent;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.StartupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.model.DownloadFile;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.CustomUserDetailsService;
import at.letto.setupservice.service.DownloadService;
import at.letto.setupservice.service.InstallService;
import at.letto.setupservice.service.UpdateService;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class DownloadController {
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    StartupConfiguration startupConfiguration;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private LettoSetupComponent lettoSetupComponent;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private CustomUserDetailsService customUserDetailsService;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private InstallService installService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private DownloadService downloadService;

    private ResponseEntity<FileSystemResource> download(String id, DownloadFile.RIGHT right, String user) throws IOException {
        DownloadFile downloadFile = this.downloadService.getFile(id);
        if (downloadFile == null) {
            throw new IOException("File not found!");
        }
        if (right != DownloadFile.RIGHT.GLOBAL && downloadFile.getRight() != right) {
            throw new RuntimeException("Permission denied!");
        }
        if (right == DownloadFile.RIGHT.USER && !downloadFile.getUser().equals(user)) {
            throw new RuntimeException("Permission denied!");
        }
        File file = downloadFile.getFile();
        FileSystemResource resource = new FileSystemResource(file);
        MediaType mediaType = MediaTypeFactory.getMediaType((Resource)resource).orElse(MediaType.APPLICATION_OCTET_STREAM);
        long fileLength = file.length();
        HttpHeaders respHeaders = new HttpHeaders();
        respHeaders.setContentType(mediaType);
        respHeaders.setContentLength(fileLength);
        respHeaders.setContentDispositionFormData("attachment", downloadFile.getFilename());
        return new ResponseEntity((Object)new FileSystemResource(file), (MultiValueMap)respHeaders, HttpStatus.OK);
    }

    @GetMapping(value={"/setup/auth/global/download/{id}"})
    public ResponseEntity<FileSystemResource> downloadGlobal(@PathVariable String id) throws IOException {
        return this.download(id, DownloadFile.RIGHT.GLOBAL, "");
    }

    @GetMapping(value={"/setup/open/download/{id}"})
    public ResponseEntity<FileSystemResource> downloadOpen(@PathVariable String id) throws IOException {
        return this.download(id, DownloadFile.RIGHT.OPEN, "");
    }

    @GetMapping(value={"/setup/auth/teacher/download/{id}"})
    public ResponseEntity<FileSystemResource> downloadTeacher(@PathVariable String id) throws IOException {
        return this.download(id, DownloadFile.RIGHT.TEACHER, "");
    }

    @GetMapping(value={"/setup/auth/student/download/{id}"})
    public ResponseEntity<FileSystemResource> downloadStudent(@PathVariable String id) throws IOException {
        return this.download(id, DownloadFile.RIGHT.STUDENT, "");
    }

    @GetMapping(value={"/setup/auth/download/{id}"})
    public ResponseEntity<FileSystemResource> downloadAuth(@PathVariable String id) throws IOException {
        return this.download(id, DownloadFile.RIGHT.AUTH, "");
    }

    @GetMapping(value={"/setup/auth/admin/download/{id}"})
    public ResponseEntity<FileSystemResource> downloadAdmin(@PathVariable String id) throws IOException {
        return this.download(id, DownloadFile.RIGHT.ADMIN, "");
    }

    public TomcatConfiguration getTomcatConfiguration() {
        return this.tomcatConfiguration;
    }

    public StartupConfiguration getStartupConfiguration() {
        return this.startupConfiguration;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public LettoSetupComponent getLettoSetupComponent() {
        return this.lettoSetupComponent;
    }

    public MicroServiceConfiguration getMicroServiceConfiguration() {
        return this.microServiceConfiguration;
    }

    public CustomUserDetailsService getCustomUserDetailsService() {
        return this.customUserDetailsService;
    }

    public AnalyzeService getAnalyzeService() {
        return this.analyzeService;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }

    public InstallService getInstallService() {
        return this.installService;
    }

    public CmdService getCmdService() {
        return this.cmdService;
    }

    public DownloadService getDownloadService() {
        return this.downloadService;
    }

    public void setTomcatConfiguration(TomcatConfiguration tomcatConfiguration) {
        this.tomcatConfiguration = tomcatConfiguration;
    }

    public void setStartupConfiguration(StartupConfiguration startupConfiguration) {
        this.startupConfiguration = startupConfiguration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setLettoSetupComponent(LettoSetupComponent lettoSetupComponent) {
        this.lettoSetupComponent = lettoSetupComponent;
    }

    public void setMicroServiceConfiguration(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
    }

    public void setCustomUserDetailsService(CustomUserDetailsService customUserDetailsService) {
        this.customUserDetailsService = customUserDetailsService;
    }

    public void setAnalyzeService(AnalyzeService analyzeService) {
        this.analyzeService = analyzeService;
    }

    public void setUpdateService(UpdateService updateService) {
        this.updateService = updateService;
    }

    public void setInstallService(InstallService installService) {
        this.installService = installService;
    }

    public void setCmdService(CmdService cmdService) {
        this.cmdService = cmdService;
    }

    public void setDownloadService(DownloadService downloadService) {
        this.downloadService = downloadService;
    }
}

