/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.service.LettoService;
import at.letto.tools.DockerComposeEnvFile;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.springframework.stereotype.Component;

@Component
public class DockerConfiguration {
    MicroServiceConfiguration microServiceConfiguration;
    LettoService lettoService;
    private Hashtable<String, String> setupConfig = null;

    public DockerConfiguration(MicroServiceConfiguration microServiceConfiguration, LettoService lettoService) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.lettoService = lettoService;
        this.setupConfig = this.initSetupConfig();
        this.loadConfiguration();
    }

    private Hashtable<String, String> initSetupConfig() {
        Hashtable<String, String> c = new Hashtable<String, String>();
        c.put("MYSQL_ROOT_PASSWORD", "verdi32");
        c.put("MYSQL_HOST", "mysql-letto");
        c.put("PHP_MYADMIN_HOST", "phpmyadmin");
        c.put("PHP_MYADMIN_PORT", "3381");
        c.put("DOMAIN_NAME", "letto.schule.at");
        c.put("EMAIL", "werner.damboeck@letto.at");
        c.put("DOCKER_BASE", this.microServiceConfiguration.getLettoPathDocker());
        c.put("MYSQL_DATABASE_PATH", this.microServiceConfiguration.getLettoPathDocker() + "/storage/mysql-letto");
        c.put("MYSQL_DUMP_PATH", this.microServiceConfiguration.getLettoPathDocker() + "/storage/mysql-server-dump");
        c.put("MYSQL_BACKUP_PATH", this.microServiceConfiguration.getLettoPathDocker() + "/storage/mysql-backup");
        c.put("HTML_PATH", this.microServiceConfiguration.getLettoPathDocker() + "/html");
        c.put("SCRIPT_PATH", this.microServiceConfiguration.getLettoPathDocker() + "/scripts");
        c.put("PROXY_PATH", this.microServiceConfiguration.getLettoPathDocker() + "/proxy");
        c.put("VOLUME_IMAGES", this.microServiceConfiguration.getLettoPathDocker() + "/storage/images");
        c.put("VOLUME_DATABASE", this.microServiceConfiguration.getLettoPathDocker() + "/storage/database");
        c.put("VOLUME_JS", this.microServiceConfiguration.getLettoPathDocker() + "/js");
        c.put("VOLUME_PHOTOS", this.microServiceConfiguration.getLettoPathDocker() + "/storage/photos");
        c.put("VOLUME_PLUGINS", this.microServiceConfiguration.getLettoPathDocker() + "/storage/plugins");
        c.put("VOLUME_PROJEKTE", this.microServiceConfiguration.getLettoPathDocker() + "/storage/projekte");
        c.put("VOLUME_PRINT", this.microServiceConfiguration.getLettoPathDocker() + "/storage/print");
        c.put("VOLUME_EXPORT", this.microServiceConfiguration.getLettoPathDocker() + "/storage/export");
        c.put("VOLUME_LOG", this.microServiceConfiguration.getLettoPathDocker() + "/log");
        c.put("LETTO_PORT", "8080");
        c.put("LETTO_AJP_PORT", "8009");
        c.put("LETTO_MEMORY", "300M");
        c.put("LETTO_MYSQL_PASSWORD", "verdi32");
        c.put("LETTO_HOST", "lettoserver");
        c.put("LETTO_SCHOOL", "htlstp");
        c.put("HTTP_PORT", "80");
        c.put("HTTPS_PORT", "443");
        return c;
    }

    public boolean checkIfConfigured() {
        File f = new File(this.microServiceConfiguration.getSetupPathEnv());
        return f.isFile();
    }

    public void loadConfiguration() {
        File f = new File(this.microServiceConfiguration.getSetupPathEnv());
        try {
            DockerComposeEnvFile.readFile((File)f, (Hashtable)this.setupConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveConfiguration() {
        File f = new File(this.microServiceConfiguration.getSetupPathEnv());
        try {
            DockerComposeEnvFile.writeFile((File)f, (Hashtable)this.setupConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector<String> getSetupPaths() {
        Vector<String> ret = new Vector<String>();
        ret.add((String)this.setupConfig.get("DOCKER_BASE") + "/storage");
        ret.add((String)this.setupConfig.get("MYSQL_DUMP_PATH"));
        ret.add((String)this.setupConfig.get("MYSQL_BACKUP_PATH"));
        ret.add((String)this.setupConfig.get("HTML_PATH"));
        ret.add((String)this.setupConfig.get("HTML_PATH") + "/letto");
        ret.add((String)this.setupConfig.get("SCRIPT_PATH"));
        ret.add((String)this.setupConfig.get("PROXY_PATH"));
        ret.add((String)this.setupConfig.get("PROXY_PATH") + "/conf.d");
        ret.add((String)this.setupConfig.get("DOCKER_BASE") + "/compose");
        ret.add((String)this.setupConfig.get("DOCKER_BASE") + "/compose/letto");
        ret.add((String)this.setupConfig.get("VOLUME_IMAGES"));
        ret.add((String)this.setupConfig.get("VOLUME_JS"));
        ret.add((String)this.setupConfig.get("VOLUME_PHOTOS"));
        ret.add((String)this.setupConfig.get("VOLUME_PLUGINS"));
        ret.add((String)this.setupConfig.get("VOLUME_PROJEKTE"));
        ret.add((String)this.setupConfig.get("VOLUME_PRINT"));
        ret.add((String)this.setupConfig.get("VOLUME_EXPORT"));
        ret.add((String)this.setupConfig.get("VOLUME_LOG"));
        ret.add((String)this.setupConfig.get("VOLUME_LOG") + "/letto");
        ret.add((String)this.setupConfig.get("VOLUME_PHOTOS") + "/" + (String)this.setupConfig.get("LETTO_SCHOOL"));
        ret.add((String)this.setupConfig.get("VOLUME_PROJEKTE") + "/" + (String)this.setupConfig.get("LETTO_SCHOOL"));
        ret.add((String)this.setupConfig.get("VOLUME_LOG") + "/letto/" + (String)this.setupConfig.get("LETTO_SCHOOL"));
        return ret;
    }

    public File getSetupFile() {
        return new File(this.microServiceConfiguration.getSetupPathEnv());
    }
}

