/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice;

import at.letto.config.properties.LettoProperties;
import at.letto.tools.Cmd;
import at.letto.tools.ServerStatus;
import java.io.File;
import java.security.CodeSource;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class SetupserviceApplication {
    private static ConfigurableApplicationContext context;

    public static String getRootPath(Class mainClass) {
        try {
            CodeSource codeSource = mainClass.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            String jarDir = jarFile.getParentFile().getPath();
            return jarDir;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static void main(String[] args) {
        LettoProperties.set_ROOT_PATH(SetupserviceApplication.class);
        LettoProperties lettoProperties = LettoProperties.loadApplicationProperties();
        File restartfile = new File(LettoProperties.ROOT_PATH + "/restart.setup");
        restartfile.delete();
        context = SpringApplication.run(SetupserviceApplication.class, (String[])args);
        System.out.println("\nsetup-service was loaded.\n\nConnect with browser to " + lettoProperties.getSetupServiceUri());
    }

    public static void restart() {
        ApplicationArguments args = (ApplicationArguments)context.getBean(ApplicationArguments.class);
        Thread thread = new Thread(() -> {
            System.out.println("lettosetup soll neu gestartet werden!");
            if (ServerStatus.isLinux()) {
                try {
                    File restartfile = new File(LettoProperties.ROOT_PATH + "/restart.setup");
                    restartfile.createNewFile();
                    System.out.println("lettosetup wird gestoppt.");
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ServerStatus.isWindows()) {
                context.close();
                Cmd.systemcall((String)(LettoProperties.ROOT_PATH + "/startlettosetup.bat"));
                System.out.println("startlettosetup.bat wurde gestartet! Setup wird beendet!");
                System.exit(0);
            }
            System.out.println("lettosetup kann nicht neu gestartet werden!");
        });
        thread.setDaemon(false);
        thread.start();
    }
}

