/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.service;

import at.letto.lti.dto.LoginDataDTO;
import at.letto.lti.service.LTIDataService;
import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LTIJWTService {
    static final Logger log = LoggerFactory.getLogger(LTIJWTService.class);
    @Autowired
    LTIDataService ltiDataService;
    String error;
    private static long id = 0L;

    public Jws<Claims> validateState(String state) {
        return Jwts.parser().setSigningKeyResolver((SigningKeyResolver)new /* Unavailable Anonymous Inner Class!! */).parseClaimsJws(state);
    }

    public Jws<Claims> validateJWT(String jwt) {
        return Jwts.parser().setSigningKeyResolver((SigningKeyResolver)new /* Unavailable Anonymous Inner Class!! */).parseClaimsJws(jwt);
    }

    public LoginDataDTO getLoginDataFromJWT(String jwt) {
        LoginDataDTO dto = new LoginDataDTO();
        try {
            DecodedJWT decoded = JWT.decode((String)jwt);
            dto.setUsername(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/ext").asMap().get("user_username").toString());
            try {
                dto.setServer(decoded.getClaim("iss").asString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setClientid(decoded.getClaim("aud").asString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setKursname(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/custom").asMap().get("kursname").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setLinktext(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/custom").asMap().get("linktext").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setTarget(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/custom").asMap().get("target").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setEmail(decoded.getClaim("email").asString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setName(decoded.getClaim("name").asString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setVorname(decoded.getClaim("given_name").asString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setFamilienname(decoded.getClaim("family_name").asString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setAktivitaet(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/resource_link").asMap().get("title").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setAktivitaetId((long)Integer.parseInt(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/resource_link").asMap().get("id").toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setMoodlekurs(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/context").asMap().get("title").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setMoodlekursLabel(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/context").asMap().get("label").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setMoodlekursId((long)Integer.parseInt(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/context").asMap().get("id").toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                List roles = decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/roles").asList(String.class);
                for (String role : roles) {
                    if (role.split("#").length == 2) {
                        dto.getRoles().add(role.split("#")[1]);
                        continue;
                    }
                    if (role.length() <= 0) continue;
                    dto.getRoles().add(role);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setMoodlekurs(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/context").asMap().get("title").toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dto.setLocale(decoded.getClaim("https://purl.imsglobal.org/spec/lti/claim/launch_presentation").asMap().get("locale").toString());
            }
            catch (Exception exception) {}
        }
        catch (JWTDecodeException exception) {
            log.error("Invalid Token");
        }
        return dto;
    }

    public synchronized long getId() {
        return id++;
    }
}

