/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service;

import at.letto.data.config.LoggingConfiguration;
import at.letto.data.config.MicroServiceConfiguration;
import at.letto.data.config.TomcatConfiguration;
import at.letto.service.image.ImageServiceDto;
import at.letto.service.rest.RestImageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LettoService {
    private Logger logger = LoggerFactory.getLogger(LettoService.class);
    private TomcatConfiguration tomcatConfiguration;
    private MicroServiceConfiguration microServiceConfiguration;
    private LoggingConfiguration loggingConfiguration;
    private RestImageService imageService = null;

    public LettoService(TomcatConfiguration tomcatConfiguration, MicroServiceConfiguration microServiceConfiguration, LoggingConfiguration loggingConfiguration) {
        this.tomcatConfiguration = tomcatConfiguration;
        this.microServiceConfiguration = microServiceConfiguration;
        this.loggingConfiguration = loggingConfiguration;
    }

    public synchronized RestImageService getImageService() {
        if (this.imageService == null) {
            try {
                this.imageService = new RestImageService(this.microServiceConfiguration.getImageServiceUri(), this.microServiceConfiguration.getImageServiceUser(), this.microServiceConfiguration.getImageServicePassword(), ImageServiceDto.SERVICEMODE.parse((String)this.microServiceConfiguration.getImageServiceMode()), this.microServiceConfiguration.getImageServiceTempDir());
            }
            catch (Exception ex) {
                this.logger.error("Imageservice kann nicht geladen werden von " + this.microServiceConfiguration.getImageServiceUri());
            }
        }
        return this.imageService;
    }
}

