/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service;

import at.letto.beurteilung.dto.BeurteilungDTO;
import at.letto.beurteilung.dto.FremdLehrerDTO;
import at.letto.beurteilung.dto.KlassenBeurteilungDTO;
import at.letto.beurteilung.dto.KlassenInfoDTO;
import at.letto.beurteilung.dto.KompetenzBeurteilungsDTO;
import at.letto.beurteilung.dto.LehrerInfoDTO;
import at.letto.beurteilung.dto.NoteDTO;
import at.letto.beurteilung.dto.StudentDto;
import at.letto.beurteilung.dto.StudentGroupDto;
import at.letto.beurteilung.dto.TestDTO;
import at.letto.beurteilung.dto.TestPunkteDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsartDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsconfigDTO;
import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.BeurteilungEntity;
import at.letto.data.entity.BeurteilungsartEntity;
import at.letto.data.entity.KlassenbeurteilungEntity;
import at.letto.data.entity.KompetenzBeurteilungEntity;
import at.letto.data.entity.KompetenzEntity;
import at.letto.data.entity.LehrerKlasseEntity;
import at.letto.data.entity.NotenEntity;
import at.letto.data.entity.UserEntity;
import at.letto.data.repository.BeurteilungEntityRepository;
import at.letto.data.repository.KlassenbeurteilungEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.BeurteilungConfigService;
import at.letto.dto.ObjAndMsg;
import at.letto.dto.PairIntString;
import at.letto.service.interfaces.BeurteilungDataService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

@Service
public class BeurteilungService
implements BeurteilungDataService {
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private BeurteilungConfigService beurteilungConfigService;

    public String changeKlassenbeurteilungsGewicht(int idKb, double gewicht) {
        AtomicReference ret = new AtomicReference();
        KlassenbeurteilungEntityRepository kbRepo = this.allRepositories.klassenbeurteilungEntityRepository;
        kbRepo.updateGewicht(idKb, gewicht);
        return "";
    }

    public String delBeurteilung(int id) {
        try {
            this.allRepositories.beurteilungEntityRepository.deleteById((Object)id);
        }
        catch (EmptyResultDataAccessException e) {
            return "Beurteilung mit der id = " + id + " existiert nicht!";
        }
        catch (Exception e1) {
            return "Fehler beim L\u00f6schen der Beurteilung!";
        }
        return "";
    }

    public String delBeurteilungenTestversuch(int id) {
        try {
            this.allRepositories.beurteilungEntityRepository.delBeurteilungenTestversuch(id);
        }
        catch (EmptyResultDataAccessException e) {
            return "Testversuch mit der id = " + id + " existiert nicht!";
        }
        catch (Exception e1) {
            return "Fehler beim L\u00f6schen der Beurteilungen zu einem Testversuch!";
        }
        return "";
    }

    public String delKlassenBeurteilung(int id) {
        try {
            this.allRepositories.klassenbeurteilungEntityRepository.deleteById((Object)id);
        }
        catch (EmptyResultDataAccessException e) {
            return "Klassenweise Beurteilung mit der id = " + id + " existiert nicht!";
        }
        catch (Exception e1) {
            return "Fehler beim L\u00f6schen der Klassenweisen Beurteilung!";
        }
        return "";
    }

    public ObjAndMsg<BeurteilungDTO> delOnlineTest(BeurteilungDTO b) {
        if (b.getIdActivity() == 0) {
            return new ObjAndMsg((Object)b, "ID der Aktivit\u00e4t ist 0");
        }
        int idAct = b.getIdActivity();
        this.allRepositories.activityEntityRepository.findById((Object)idAct).ifPresent(act -> {
            try {
                this.allRepositories.activityEntityRepository.deleteById((Object)idAct);
                this.allRepositories.beurteilungEntityRepository.findById((Object)b.getId()).ifPresent(beurt -> {
                    beurt.setActivity(null);
                    this.allRepositories.beurteilungEntityRepository.save(beurt);
                    b.setIdActivity(0);
                    b.setActivityName("");
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return new ObjAndMsg((Object)b);
    }

    public ObjAndMsg<KlassenBeurteilungDTO> delOnlineTest(KlassenBeurteilungDTO b, int idSchema) {
        if (b.getIdActivity() == 0) {
            return new ObjAndMsg((Object)b);
        }
        b.setIdActivity(0);
        b.setActivityName("");
        KlassenBeurteilungDTO kb = b.getParent() != null ? b.getParent() : b;
        this.saveKlassenBeurteilung(kb, idSchema);
        return new ObjAndMsg((Object)b);
    }

    @Transactional
    public Optional<BeurteilungDTO> findBeurteilung(int id) {
        return this.allRepositories.beurteilungEntityRepository.findById((Object)id).map(b -> this.toDto(b, null));
    }

    @Transactional
    public Optional<BeurteilungDTO> findBeurteilungFromKlassenbeurteilungAndUser(int idKlassenbeurteilung, int idUser, int idSchema) {
        return this.allRepositories.beurteilungEntityRepository.findBeurteilungFromKlassenbeurteilungAndUser(idKlassenbeurteilung, idUser).map(b -> this.toDto(b, null));
    }

    @Transactional
    public Optional<Integer> findIdLkBeurteilung(int id) {
        BeurteilungEntityRepository repo = this.allRepositories.beurteilungEntityRepository;
        BeurteilungEntity b = repo.findParentBeurteilung(id).orElse(repo.findById((Object)id).orElse(null));
        if (b != null) {
            return Optional.of(b.getLehrerKlasse().getId());
        }
        return Optional.empty();
    }

    @Transactional
    public Optional<KlassenBeurteilungDTO> findKlassenbeurteilung(int id) {
        return this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)id).map(k -> this.toDto(k));
    }

    @Transactional
    public Optional<KlassenBeurteilungDTO> findParentKlassenbeurteilung(int id) {
        return this.allRepositories.beurteilungEntityRepository.findParentKlassenbeurteilung(id).map(kb -> this.toDto(kb));
    }

    @Transactional
    public Optional<NoteDTO> findNote(int idNote) {
        return this.allRepositories.notenEntityRepository.findById((Object)idNote).map(n -> this.toDto(n));
    }

    public void saveBeurt() {
        BeurteilungEntity b = new BeurteilungEntity();
        b.setNote("Sehr Gut");
        b.setDatum(new Date());
        UserEntity u = this.allRepositories.userEntityRepository.findById((Object)7).orElse(null);
        b.setUser(u);
        BeurteilungEntity bRet = (BeurteilungEntity)this.allRepositories.beurteilungEntityRepository.save((Object)b);
    }

    @Transactional
    public BeurteilungDTO saveBeurteilung(BeurteilungDTO b, int idSchema) {
        BeurteilungsconfigDTO schema = this.beurteilungConfigService.loadSchemaByLehrerKlasse(b.getIdLk().intValue()).orElse(null);
        BeurteilungEntity beurteilung = this.createBeurteilung(b, schema, true);
        BeurteilungEntity bRet = (BeurteilungEntity)this.allRepositories.beurteilungEntityRepository.saveAndFlush((Object)beurteilung);
        return bRet != null ? this.toDto(bRet, schema) : null;
    }

    public KlassenBeurteilungDTO saveKlassenBeurteilung(KlassenBeurteilungDTO kbDto, int idSchema) {
        BeurteilungsconfigDTO schema = this.beurteilungConfigService.loadSchemaByLehrerKlasse(kbDto.getIdLk()).orElse(null);
        KlassenbeurteilungEntity kb = this.createKlassenBeurteilung(kbDto, schema, true);
        KlassenbeurteilungEntity kbErg = (KlassenbeurteilungEntity)this.allRepositories.klassenbeurteilungEntityRepository.save((Object)kb);
        if (kbErg == null) {
            return null;
        }
        return this.toDto(kbErg);
    }

    public NoteDTO saveNote(NoteDTO n) {
        LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)n.getIdLk()).orElse(null);
        if (lk == null) {
            throw new RuntimeException("LehrerKlasse-Objekt konnte nicht zugeordnet werden!");
        }
        NotenEntity note = this.allRepositories.notenEntityRepository.findById((Object)n.getId()).orElse(new NotenEntity());
        if (n.getId() == 0) {
            note.setLehrerKlasse(lk);
            note.setSemester(n.getSemestrierung());
            this.allRepositories.userEntityRepository.findById((Object)n.getIdUser()).ifPresent(u -> note.setUser(u));
        }
        note.setMahnung(Boolean.valueOf(n.isMahnung()));
        note.setNote(n.getNote());
        note.getNegativeDeskriptoren().clear();
        note.getNegativerLehrinhalt().clear();
        if (note.getNote().equals("5")) {
            List ids = n.getNegativeDeskriptoren().keySet().stream().filter(id -> (Boolean)n.getNegativeDeskriptoren().get(id)).collect(Collectors.toList());
            note.getNegativeDeskriptoren().addAll(this.allRepositories.deskriptorEntityRepository.findAllById(ids));
            ids = n.getNegativeLehrinhalte().keySet().stream().filter(id -> (Boolean)n.getNegativeLehrinhalte().get(id)).collect(Collectors.toList());
            note.getNegativerLehrinhalt().addAll(this.allRepositories.lehrinhaltEntityRepository.findAllById(ids));
        }
        NotenEntity noteSaved = (NotenEntity)this.allRepositories.notenEntityRepository.save((Object)note);
        return this.toDto(noteSaved);
    }

    public Optional<Integer> findLehrerID(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findLehrerID(idLk);
    }

    public List<BeurteilungDTO> findByLK(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findByLK(idLk);
    }

    public List<BeurteilungDTO> findGlobalByLK(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findGlobalByLK(idLk);
    }

    public List<BeurteilungDTO> findSubBeurteilungen(Set<Integer> ids) {
        return this.allRepositories.beurteilungEntityRepository.findSubBeurteilungen(ids);
    }

    public Optional<BeurteilungDTO> findBeurteilungDto(int id) {
        return this.allRepositories.beurteilungEntityRepository.findBeurteilungDto(id);
    }

    public List<FremdLehrerDTO> findFremdLehrer(Set<Integer> ids) {
        return this.allRepositories.beurteilungEntityRepository.findFremdLehrer(ids);
    }

    public List<KompetenzBeurteilungsDTO> findKompetenzen(Set<Integer> ids) {
        return this.allRepositories.beurteilungEntityRepository.findKompetenzen(ids);
    }

    public List<KlassenBeurteilungDTO> findKlassenBeurteilungDto(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findKlassenBeurteilungDto(idLk);
    }

    public List<KlassenBeurteilungDTO> findSubKlassenBeurteilungDto(Set<Integer> idsParent) {
        return this.allRepositories.beurteilungEntityRepository.findSubKlassenBeurteilungDto(idsParent);
    }

    public List<KlassenBeurteilungDTO> findGlobalKlassenBeurteilungDto(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findGlobalKlassenBeurteilungDto(idLk);
    }

    public List<BeurteilungDTO> findByKlasse(int idKlasse) {
        return this.allRepositories.beurteilungEntityRepository.findByKlasse(idKlasse);
    }

    public List<PairIntString> findTestsWithFullPath(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findTestsWithFullPath(idLk);
    }

    public List<PairIntString> findTestsGlobalWithFullPath(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findTestsGlobalWithFullPath(idLk);
    }

    public List<PairIntString> findTestsFullPathWinterSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsFullPathWinterSemester(idLk, semester);
    }

    public List<PairIntString> findTestsGlobalFullPathWinterSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsGlobalFullPathWinterSemester(idLk, semester);
    }

    public List<PairIntString> findTestsFullPathSommerSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsFullPathSommerSemester(idLk, semester);
    }

    public List<PairIntString> findTestsGlobalFullPathSommerSemester(int idLk, Date semester) {
        return this.allRepositories.beurteilungEntityRepository.findTestsGlobalFullPathSommerSemester(idLk, semester);
    }

    public List<TestDTO> findTests(Set<Integer> idAct) {
        return this.allRepositories.beurteilungEntityRepository.findTests(idAct);
    }

    public Map<Integer, List<Integer>> findTestGroups(Set<Integer> idAct) {
        return this.allRepositories.beurteilungEntityRepository.findTestGroups(idAct);
    }

    public List<TestPunkteDTO> loadTestPoints(Set<Integer> idAct) {
        return this.allRepositories.beurteilungEntityRepository.loadTestPoints(idAct);
    }

    public List<NoteDTO> findNoten(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findNoten(idLk);
    }

    public List<StudentDto> findStudents(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findStudents(idLk);
    }

    public List<StudentGroupDto> findStudentGroups(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findStudentGroups(idLk);
    }

    public Optional<KlassenInfoDTO> findKlassenInfo(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findKlassenInfo(idLk);
    }

    public List<LehrerInfoDTO> findLehrerInKlasse(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findLehrerInKlasse(idLk);
    }

    public List<Integer> findBeurteilungenSchuljahr(int idSchuljahr) {
        return this.allRepositories.beurteilungEntityRepository.findBeurteilungenSchuljahr(idSchuljahr);
    }

    public List<String> findActivitiesInKlasse(int idLk) {
        return this.allRepositories.beurteilungEntityRepository.findActivitiesInKlasse(idLk);
    }

    private NoteDTO toDto(NotenEntity nEnt) {
        NoteDTO n = new NoteDTO();
        n.setId(nEnt.getId().intValue());
        n.setIdLk(nEnt.getLehrerKlasse().getId());
        n.setIdUser(nEnt.getUser().getId());
        n.setNote(nEnt.getNote());
        n.setMahnung(nEnt.getMahnung().booleanValue());
        n.setSemestrierung(nEnt.getSemester());
        return n;
    }

    private BeurteilungDTO toDto(BeurteilungEntity bEnt, BeurteilungsconfigDTO schema) {
        BeurteilungDTO b = this.toDtoIntern(bEnt);
        List kompetenzen = bEnt.getKompetenzenLink().stream().map(kl -> new KompetenzBeurteilungsDTO(b.getId(), kl.getKompetenz().getId().intValue(), kl.getKompetenz().getKompetenz(), kl.getLevel())).collect(Collectors.toList());
        b.setKompetenzen(kompetenzen);
        UserEntity fl = bEnt.getFremdLehrer();
        if (fl != null) {
            String name = fl.getNachname() + " " + fl.getVorname();
            b.setFremdLehrer(name);
            b.setIdFremdLehrer(bEnt.getFremdLehrer().getId().intValue());
        }
        bEnt.getSubBeurteilungen().forEach(sub -> {
            BeurteilungDTO subDto = this.toDtoIntern(sub);
            subDto.setParent(b);
            b.getSubBeurteilungen().add(subDto);
        });
        if (bEnt.getActivity() != null) {
            b.setIdActivity(bEnt.getActivity().getId().intValue());
            b.setActivityName(bEnt.getActivity().getName());
        }
        if (schema != null) {
            b.mark(schema);
        }
        b.setDateOK(true);
        return b;
    }

    private BeurteilungDTO toDtoIntern(BeurteilungEntity bEnt) {
        BeurteilungDTO b = new BeurteilungDTO();
        b.setId(bEnt.getId().intValue());
        b.setIdLk(bEnt.getLehrerKlasse() != null ? bEnt.getLehrerKlasse().getId() : null);
        b.setIdUser(bEnt.getUser() != null ? bEnt.getUser().getId() : null);
        b.setIdKlassenbeurteilung(bEnt.getKlassenBeurteilung() != null ? bEnt.getKlassenBeurteilung().getId() : 0);
        b.setBeurteilungsart(bEnt.getBeurteilungsartGlobal().getName());
        b.setBezeichnerBeurteilungsart(bEnt.getBezeichnerBeurteilungsart());
        b.setDatum(bEnt.getDatum());
        b.setNote(bEnt.getNote());
        b.setProzent(bEnt.getProzent());
        b.setGewicht(bEnt.getGewicht().doubleValue());
        b.setFragetext(bEnt.getFragetext());
        b.setInput(b.getInput());
        return b;
    }

    private KlassenBeurteilungDTO toDto(KlassenbeurteilungEntity kb) {
        KlassenBeurteilungDTO kbDto = new KlassenBeurteilungDTO();
        kbDto.setId(kb.getId().intValue());
        kbDto.setIdLk(kb.getLehrerKlasse().getId().intValue());
        kbDto.setName(kb.getName());
        kbDto.setAufgabenstellung(kb.getAufgabenstellung());
        if (kb.getBeurteilungsartGlobal() != null) {
            kbDto.setBeurteilungsart(kb.getBeurteilungsartGlobal().getName());
        }
        kbDto.setBezeichnerBeurteilungsart(kb.getBezeichnerBeurteilungsart());
        kbDto.setGewichtung(kb.getGewicht().doubleValue());
        kbDto.setDatum(kb.getDatum());
        if (kb.getActivity() != null) {
            kbDto.setIdActivity(kb.getActivity().getId().intValue());
            kbDto.setActivityName(kb.getActivity().getName());
        }
        if (kb.getSelKompetenz() != null) {
            kbDto.setIdKompetenz(kb.getId().intValue());
            kbDto.setKompetenzen(kb.getSelKompetenz().getKompetenz());
        }
        kbDto.setLevel(kb.getSelectedLevel());
        kb.getSubKlassenBeurteilungen().forEach(sub -> {
            KlassenBeurteilungDTO subDto = this.toDto(sub);
            subDto.setParent(kbDto);
            kbDto.getSubKlassenbeurteilungen().add(subDto);
        });
        return kbDto;
    }

    private BeurteilungEntity createBeurteilung(BeurteilungDTO b, BeurteilungsconfigDTO schema, boolean runtimeException) {
        BeurteilungEntity beurteilung = b.getId() > 0 ? this.allRepositories.beurteilungEntityRepository.findById((Object)b.getId()).orElse(new BeurteilungEntity()) : new BeurteilungEntity();
        beurteilung.setDatum(b.getDatum());
        beurteilung.setFragetext(b.getFragetext());
        beurteilung.setGewicht(Double.valueOf(b.getGewicht()));
        beurteilung.setNote(b.getNote());
        beurteilung.setProzent(b.getProzent());
        beurteilung.setInput(b.getInput());
        BeurteilungsartDTO baDTO = schema.getBeurteilungsart(b);
        if (baDTO == null && runtimeException) {
            throw new RuntimeException("Angeforderte Beurteilungsart konnte nicht gefunden werden!");
        }
        BeurteilungsartEntity ba = this.allRepositories.beurteilungsartEntityRepository.findById((Object)baDTO.getId()).orElse(null);
        if (ba == null && runtimeException) {
            throw new RuntimeException("Angeforderte Beurteilungsartkonne nicht gefunden werden!");
        }
        beurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        beurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        this.allRepositories.userEntityRepository.findById((Object)b.getIdFremdLehrer()).ifPresent(fl -> beurteilung.setFremdLehrer(fl));
        this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)b.getIdKlassenbeurteilung()).ifPresent(kb -> beurteilung.setKlassenBeurteilung(kb));
        if (b.getIdLk() != null) {
            LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)b.getIdLk()).orElse(null);
            if (lk == null && runtimeException) {
                throw new RuntimeException("Angeforderte Klasse und angeforderter Gegenstand konne nicht gefunden werden: idLK passt nicht");
            }
            beurteilung.setLehrerKlasse(lk);
        }
        if (b.getIdUser() != null) {
            UserEntity u = this.allRepositories.userEntityRepository.findById((Object)b.getIdUser()).orElse(null);
            if (u == null && runtimeException) {
                throw new RuntimeException("Angeforderter User konnte nicht in der Datenbank gefunden werden!");
            }
            beurteilung.setUser(u);
        }
        beurteilung.getKompetenzenLink().clear();
        Map<Integer, KompetenzEntity> kompHash = this.allRepositories.kompetenzEntityRepository.findAllById((Iterable)b.getKompetenzen().stream().map(k -> k.getIdKompetenz()).collect(Collectors.toList())).stream().collect(Collectors.toMap(KompetenzEntity::getId, k -> k));
        b.getKompetenzen().forEach(kl -> {
            KompetenzBeurteilungEntity klEnt = new KompetenzBeurteilungEntity();
            klEnt.setBeurteilung(beurteilung);
            klEnt.setLevel(kl.getLevel());
            klEnt.setKompetenz((KompetenzEntity)kompHash.get(kl.getIdKompetenz()));
            beurteilung.getKompetenzenLink().add(klEnt);
        });
        beurteilung.getSubBeurteilungen().clear();
        b.getSubBeurteilungen().forEach(s -> {
            BeurteilungEntity sub = this.createBeurteilung(s, schema, false);
            sub.setParent(beurteilung);
            beurteilung.getSubBeurteilungen().add(sub);
        });
        return beurteilung;
    }

    private KlassenbeurteilungEntity createKlassenBeurteilung(KlassenBeurteilungDTO kbDto, BeurteilungsconfigDTO schema, boolean runtimeException) {
        KlassenbeurteilungEntity klassenBeurteilung = kbDto.getId() > 0 ? this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)kbDto.getId()).orElse(new KlassenbeurteilungEntity()) : new KlassenbeurteilungEntity();
        klassenBeurteilung.setAufgabenstellung(kbDto.getAufgabenstellung());
        klassenBeurteilung.setName(kbDto.getName());
        klassenBeurteilung.setShowDateBeurteilung(Boolean.valueOf(kbDto.isShowDateBeurteilung()));
        klassenBeurteilung.setTestAllowed(Boolean.valueOf(kbDto.isTestAllowed()));
        klassenBeurteilung.setDatum(kbDto.getDatum());
        klassenBeurteilung.setGewicht(Double.valueOf(kbDto.getGewichtung()));
        BeurteilungsartDTO baDTO = schema.getBeurteilungsart(kbDto);
        if (baDTO == null && runtimeException) {
            throw new RuntimeException("Angeforderte Beurteilungsart konnte nicht gefunden werden!");
        }
        BeurteilungsartEntity ba = this.allRepositories.beurteilungsartEntityRepository.findById((Object)baDTO.getId()).orElse(null);
        if (ba == null && runtimeException) {
            throw new RuntimeException("Angeforderte Beurteilungsartkonne nicht gefunden werden!");
        }
        klassenBeurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        klassenBeurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        klassenBeurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        klassenBeurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        klassenBeurteilung.setSubKlassenBeurteilungen(klassenBeurteilung.getSubKlassenBeurteilungen().stream().filter(s -> kbDto.getSubKlassenbeurteilungen().stream().anyMatch(x -> x.getId() == s.getId().intValue())).collect(Collectors.toList()));
        kbDto.getSubKlassenbeurteilungen().forEach(kbSub -> {
            Optional<KlassenbeurteilungEntity> optSub = klassenBeurteilung.getSubKlassenBeurteilungen().stream().filter(s -> s.getId().intValue() == kbSub.getId() && s.getId() > 0).findFirst();
            KlassenbeurteilungEntity sub = optSub.isPresent() ? optSub.get() : new KlassenbeurteilungEntity();
            sub.setParent(klassenBeurteilung);
            klassenBeurteilung.getSubKlassenBeurteilungen().add(sub);
            sub.setName(kbSub.getName());
            sub.setGewicht(Double.valueOf(kbSub.getGewichtung()));
            if (kbSub.getIdActivity() > 0) {
                this.allRepositories.activityEntityRepository.findById((Object)kbSub.getIdActivity()).ifPresent(a -> sub.setActivity(a));
            } else if (sub.getActivity() != null) {
                ActivityEntity a2 = sub.getActivity();
                a2.setKlassenBeurteilung(null);
                sub.setActivity(null);
            }
        });
        if (kbDto.getIdLk() != 0) {
            LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)kbDto.getIdLk()).orElse(null);
            if (lk == null && runtimeException) {
                throw new RuntimeException("Angeforderte Klasse und angeforderter Gegenstand konne nicht gefunden werden: idLK passt nicht");
            }
            klassenBeurteilung.setLehrerKlasse(lk);
        }
        klassenBeurteilung.setSelKompetenz((KompetenzEntity)this.allRepositories.kompetenzEntityRepository.findById((Object)kbDto.getIdKompetenz()).orElse(null));
        klassenBeurteilung.setSelectedLevel(kbDto.getLevel());
        if (kbDto.getIdFremdlehrer() > 0) {
            this.allRepositories.userEntityRepository.findById((Object)kbDto.getIdFremdlehrer()).ifPresent(fl -> klassenBeurteilung.setFremdLehrer(fl));
        }
        return klassenBeurteilung;
    }
}

