/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.TestFrageEntity;
import at.letto.data.entity.TestGruppeEntity;
import at.letto.data.entity.TestVersuchEntity;
import at.letto.data.entity.TestsEntity;
import at.letto.tests.dto.CreateEmptyTestVersuchDTO;
import at.letto.tests.dto.SelectEmptyTestsDTO;
import at.letto.tests.dto.TestBereichDto;
import at.letto.tests.dto.TestEigenschaftsDto;
import at.letto.tests.dto.TestFrageDto;
import at.letto.tests.dto.TestGruppeDto;
import at.letto.tests.dto.TestVersuchDto;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TestVersuchEntityRepository
extends JpaRepository<TestVersuchEntity, Integer>,
JpaSpecificationExecutor<TestVersuchEntity> {
    @Query(value="select distinct v.id from TestAntwortEntity ta join ta.testDetail td join td.testVersuch v join v.test t join t.activity a where ta.timestamp > :start and ta.timestamp < :stop and a.idLk = :idLk")
    public List<Integer> findTestVersucheInTimePeriod(@Param(value="start") Date var1, @Param(value="stop") Date var2, @Param(value="idLk") int var3);

    @Query(value="select distinct new at.letto.tests.dto.CreateEmptyTestVersuchDTO(t.id, u.id)  from ActivityEntity a join a.test t , LehrerKlasseEntity lk join lk.klasse k join k.schuelerKlasses sk  join t.mode m join sk.user u where t.testDatum < :date and lk.id = a.idLk and lk.id =  :idLk and m.testversuchAnlegen=true and u.id NOT IN (   select v.user.id from TestVersuchEntity v where v.test = t and v.user = u )")
    public List<CreateEmptyTestVersuchDTO> findStudentsForCreateVersuch(@Param(value="date") Date var1, @Param(value="idLk") int var2);

    @Query(value="select distinct new at.letto.tests.dto.CreateEmptyTestVersuchDTO(t.id, u.id)  from ActivityEntity a join a.test t , LehrerKlasseEntity lk join lk.klasse k join k.schuelerKlasses sk  join t.mode m join sk.user u where t.id in :idTests and lk.id = a.idLk and u.id NOT IN (   select v.user.id from TestVersuchEntity v where v.test = t and v.user = u )")
    public List<CreateEmptyTestVersuchDTO> findStudentsForCreateVersuch(@Param(value="idTests") Set<Integer> var1);

    @Query(value="select distinct new at.letto.tests.dto.SelectEmptyTestsDTO(t.id, a.name, count(sk), false, t.mode.name)  from ActivityEntity a join a.test t , LehrerKlasseEntity lk join lk.klasse k join k.schuelerKlasses sk  join t.mode ba join sk.user u where t.testDatum < :date and lk.id = a.idLk and lk.id =  :idLk and ba.id in :beurteilungsart and u.id NOT IN (   select v.user.id from TestVersuchEntity v where v.test = t and v.user = u )group by a, t")
    public List<SelectEmptyTestsDTO> findTestsForCreateVersuch(@Param(value="date") Date var1, @Param(value="idLk") int var2, @Param(value="beurteilungsart") List<Integer> var3);

    @Query(value="select distinct new at.letto.tests.dto.SelectEmptyTestsDTO(t.id, a.name, count(distinct v), false, t.mode.name)  from ActivityEntity a join a.test t , LehrerKlasseEntity lk join lk.klasse k join k.schuelerKlasses sk  join t.mode ba join t.testVersuche v where t.testDatum < :date and lk.id = a.idLk and lk.id =  :idLk and ba.id in :beurteilungsart and v.finished = false group by a, t")
    public List<SelectEmptyTestsDTO> findOpenVersuche(@Param(value="date") Date var1, @Param(value="idLk") int var2, @Param(value="beurteilungsart") List<Integer> var3);

    @Query(value="select t from TestsEntity t where t.id = :id")
    public Optional<TestsEntity> findTestById(int var1);

    @Query(value="select g from TestGruppeEntity g where g.id = :id")
    public Optional<TestGruppeEntity> findTestGruppeById(@Param(value="id") int var1);

    @Query(value="select new at.letto.tests.dto.TestEigenschaftsDto(t.id, t.start, t.stop, t.testStart, t.testStop, t.begrenzung, t.dauer, t.fragenMischen, t.ANTWORTMISCHEN, t.FIXREIHENFOLGE,t.pdfForStudent, t.onRamp, t.ABZUGBEIMEHRFACHANTWORT, t.testResults, m.erlaubteVersuche, a.name, a.visible, m.anonym, m.name, m.gesundheitsCheck, a.idLk, kb.id, b.id, t.password, t.dontleave, t.focusLostOnSizeChange, '', a.id, t.feedback) from TestsEntity t join t.activity a left join t.mode m left join a.klassenBeurteilung kb left join a.beurteilung b where t.id = :id")
    public Optional<TestEigenschaftsDto> findTestEigenschaftenById(@Param(value="id") int var1);

    @Query(value="select x.text from GlobalconfigEntity x join x.schule s join s.abteilungen a join a.klasses k join k.lehrerKlasses lk where x.name like 'lizenz' and lk.id = :idLk")
    public Optional<String> findLicenseForTest(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.tests.dto.TestEigenschaftsDto(t.id, t.start, t.stop, t.testStart, t.testStop, t.begrenzung, t.dauer, t.fragenMischen, t.ANTWORTMISCHEN, t.FIXREIHENFOLGE,t.pdfForStudent, t.onRamp, t.ABZUGBEIMEHRFACHANTWORT, t.testResults, m.erlaubteVersuche, a.name, a.visible, m.anonym, m.name, m.gesundheitsCheck, a.idLk, kb.id, b.id, t.password, t.dontleave, t.focusLostOnSizeChange, '', a.id, t.feedback) from TestsEntity t join t.activity a left join t.mode m left join a.klassenBeurteilung kb left join a.beurteilung b where a.id = :id")
    public Optional<TestEigenschaftsDto> findTestEigenschaftenByActivityId(@Param(value="id") int var1);

    @Query(value="select v from TestVersuchEntity v where v.id = :id")
    public Optional<TestVersuchEntity> findTestVersuchById(@Param(value="id") int var1);

    @Query(value="select v from TestVersuchEntity v where v.id in :idVersuche")
    public List<TestVersuchEntity> findTestVersucheById(@Param(value="idVersuche") List<Integer> var1);

    @Query(value="select new at.letto.tests.dto.TestVersuchDto(v.id, v.user.id, v.test.id, v.gruppe.id, v.finished, v.punkteIst, v.punkteSoll, v.startdatum, v.stopdatum, v.focusLost, v.focusLostCleared, v.focusLostProtokoll, v.gruppe.gruppenName, v.indexStartQuestion, v.openTestTime,an.id, v.reihenfolge, v.user.name, concat(v.user.nachname, ' ', v.user.vorname), v.user.sokratesID ) from TestVersuchEntity v left join v.parentAnonym an where v.test.id = :idTest")
    public List<TestVersuchDto> findTestVersucheByTestId(@Param(value="idTest") int var1);

    @Query(value="select new at.letto.tests.dto.TestVersuchDto(v.id, v.user.id, v.test.id, v.gruppe.id, v.finished, v.punkteIst, v.punkteSoll, v.startdatum, v.stopdatum, v.focusLost, v.focusLostCleared, v.focusLostProtokoll, v.gruppe.gruppenName, v.indexStartQuestion, v.openTestTime,an.id, v.reihenfolge, v.user.name, concat(v.user.nachname, ' ', v.user.vorname), v.user.sokratesID ) from TestVersuchEntity v left join v.parentAnonym an where v.finished = false and v.test.id = :idTest")
    public List<TestVersuchDto> findOpenTestVersucheByTestId(@Param(value="idTest") int var1);

    @Query(value="select new at.letto.tests.dto.TestVersuchDto(v.id, v.user.id, v.test.id, v.gruppe.id, v.finished, v.punkteIst, v.punkteSoll, v.startdatum, v.stopdatum, v.focusLost, v.focusLostCleared, v.focusLostProtokoll, v.gruppe.gruppenName, v.indexStartQuestion, v.openTestTime,an.id, v.reihenfolge, v.user.name, concat(v.user.nachname, ' ', v.user.vorname), v.user.sokratesID ) from TestVersuchEntity v left join v.parentAnonym an where v.user.id = :idUser and v.test.id = :idTest")
    public List<TestVersuchDto> findTestVersucheByUserId(@Param(value="idUser") int var1, @Param(value="idTest") int var2);

    @Query(value="select new at.letto.tests.dto.TestVersuchDto(v.id, v.user.id, v.test.id, v.gruppe.id, v.finished, v.punkteIst, v.punkteSoll, v.startdatum, v.stopdatum, v.focusLost, v.focusLostCleared, v.focusLostProtokoll, v.gruppe.gruppenName, v.indexStartQuestion, v.openTestTime,an.id, v.reihenfolge, v.user.name, concat(v.user.nachname, ' ', v.user.vorname), v.user.sokratesID ) from TestVersuchEntity v left join v.parentAnonym an where v.id = :idTestversuch")
    public Optional<TestVersuchDto> findTestVersuchDto(@Param(value="idTestversuch") int var1);

    @Query(value="select new at.letto.tests.dto.TestGruppeDto(g.id, g.test.id, g.gruppenName) from TestGruppeEntity g where g.test.id = :idTest")
    public List<TestGruppeDto> findTestGruppen(@Param(value="idTest") int var1);

    @Query(value="select new at.letto.tests.dto.TestBereichDto(g.id, g.parent.id, g.gruppenName, g.prozentBereich, g.prozentForPositiv) from TestGruppeEntity g where g.parent.test.id = :idTest")
    public List<TestBereichDto> findTestBereiche(@Param(value="idTest") int var1);

    @Query(value="select f.id as id, q.id as idQuestion, f.idTestGruppe as idTestGruppe, f.points as points, f.GRUPPEVONFRAGEN_ID as gruppierung, fg.anzahl as anzahlInGruppe, q.name as name from testFrage f join question q on q.id = f.idQuestion left join fragengruppe fg on fg.ID = f.GRUPPEVONFRAGEN_ID where f.idTestGruppe in :ids order by f.testFragen_ORDER ", nativeQuery=true)
    public List<TestFrageDto> findTestFragen(@Param(value="ids") Set<Integer> var1);

    @Query(value="select f from TestFrageEntity f where f.id =:id")
    public Optional<TestFrageEntity> findTestFrageEntity(@Param(value="id") int var1);

    @Query(value="select gr.anzahl from TestVersuchEntity v join v.gruppe g join g.testFragen f join f.gruppeVonFragen gr where v.id = :idTestVersuch  group by gr.id ")
    public List<Integer> getAnzahlFragenInGruppen(@Param(value="idTestVersuch") int var1);

    @Query(value="select count(f) from TestVersuchEntity v join v.gruppe g     join g.testFragen f left join f.gruppeVonFragen gr     where gr.id is null and v.id = :idTestVersuch ")
    public long getAnzahlFragenOhneGruppen(@Param(value="idTestVersuch") int var1);

    @Query(value="select count(td) from TestDetailsEntity td join td.frage f join f.testGruppe g where td.id =:idTestDetail")
    public long checkTestDetailInTest(@Param(value="idTestDetail") int var1);

    @Query(value="select new at.letto.tests.dto.TestVersuchDto(v.id, v.user.id, v.test.id, v.gruppe.id, v.finished, v.punkteIst, v.punkteSoll, v.startdatum, v.stopdatum, v.focusLost, v.focusLostCleared, v.focusLostProtokoll, v.gruppe.gruppenName, v.indexStartQuestion, v.openTestTime,an.id, v.reihenfolge, v.user.name, concat(v.user.nachname, ' ', v.user.vorname), v.user.sokratesID ) from TestVersuchEntity v left join v.parentAnonym an  join v.test t where t.id = :idTest")
    public List<TestVersuchDto> findTestVersucheDto(@Param(value="idTest") int var1);

    @Query(value="select v from TestVersuchEntity v left join v.parentAnonym an join v.test t where t.id = :idTest")
    public List<TestVersuchEntity> findTestVersucheEntities(@Param(value="idTest") int var1);

    @Query(value="select a from ActivityEntity a where a.id = :id")
    public Optional<ActivityEntity> findActivity(@Param(value="id") int var1);

    @Query(value="select a from ActivityEntity a join a.test t where t.id = :id")
    public Optional<ActivityEntity> findActivityByTestId(@Param(value="id") int var1);
}

