/*
 * Decompiled with CFR 0.152.
 */
package at.letto.imageservice.controller;

import at.letto.imageservice.service.LettoService;
import at.letto.service.image.ImageLongDto;
import at.letto.service.image.ImageServiceDto;
import at.letto.service.image.ImageStringDto;
import at.letto.service.image.ImageStringVectorDto;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ImageController {
    private final LettoService lettoService;

    public ImageController(LettoService lettoService) {
        this.lettoService = lettoService;
    }

    @PostMapping(value={"/image/open/checkfilesystem"})
    public ResponseEntity<String> checkFilesystem(@RequestBody ImageServiceDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).checkFilesystem());
    }

    @PostMapping(value={"/image/open/checkservice"})
    public ResponseEntity<String> checkService(@RequestBody ImageServiceDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).checkService());
    }

    @PostMapping(value={"/image/open/existimage"})
    public ResponseEntity<Boolean> existImage(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).existImage(dto.getFilename()));
    }

    @PostMapping(value={"/image/open/getimageage"})
    public ResponseEntity<Long> getImageAge(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).getImageAge(dto.getFilename()));
    }

    @PostMapping(value={"/image/open/getimagsize"})
    public ResponseEntity<Long> getImageSize(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).getImageSize(dto.getFilename()));
    }

    @PostMapping(value={"/image/auth/user/delimage"})
    public ResponseEntity<Boolean> delImage(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).delImage(dto.getFilename()));
    }

    @PostMapping(value={"/image/open/geturl"})
    public ResponseEntity<String> getURL(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).getURL(dto.getFilename()));
    }

    @PostMapping(value={"/image/open/getabsurl"})
    public ResponseEntity<String> getAbsURL(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).getAbsURL(dto.getFilename()));
    }

    @PostMapping(value={"/image/auth/user/createfile"})
    public ResponseEntity<Boolean> createFile(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).createFile(dto.getFilename()));
    }

    @PostMapping(value={"/image/open/isfilenameok"})
    public ResponseEntity<Boolean> isFilenameOK(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).isFilenameOK(dto.getFilename()));
    }

    @PostMapping(value={"/image/open/getextension"})
    public ResponseEntity<String> getExtension(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).getExtension(dto.getFilename()));
    }

    @PostMapping(value={"/image/auth/user/saveimage"})
    public ResponseEntity<String> saveImage(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).saveImage((String)dto.getStrings().get(0), dto.getFilename()));
    }

    @PostMapping(value={"/image/auth/user/savebase64image"})
    public ResponseEntity<String> saveBase64Image(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).saveBase64Image((String)dto.getStrings().get(0), (String)dto.getStrings().get(1)));
    }

    @PostMapping(value={"/image/auth/user/saveurlimage"})
    public ResponseEntity<String> saveURLImage(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).saveURLImage((String)dto.getStrings().get(0)));
    }

    @PostMapping(value={"/image/open/loadimagebase64"})
    public ResponseEntity<String> loadImageBase64(@RequestBody ImageStringDto dto) {
        return ResponseEntity.ok((Object)this.lettoService.getImageService(dto.getServicemode()).loadImageBase64(dto.getFilename()));
    }

    @PostMapping(value={"/image/open/getimages"})
    public ResponseEntity<ImageStringVectorDto> getImages(@RequestBody ImageServiceDto dto) {
        return ResponseEntity.ok((Object)new ImageStringVectorDto(this.lettoService.getImageService(dto.getServicemode()).getImages()));
    }

    @PostMapping(value={"/image/auth/user/delimages"})
    public ResponseEntity<ImageStringVectorDto> delImages(@RequestBody ImageStringVectorDto dto) {
        return ResponseEntity.ok((Object)new ImageStringVectorDto(this.lettoService.getImageService(dto.getServicemode()).delImages(dto.getStrings())));
    }

    @PostMapping(value={"/image/open/getimagesolderthan"})
    public ResponseEntity<ImageStringVectorDto> getImagesOlderThan(@RequestBody ImageLongDto dto) {
        return ResponseEntity.ok((Object)new ImageStringVectorDto(this.lettoService.getImageService(dto.getServicemode()).getImagesOlderThan(dto.getValue())));
    }
}

