/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.utils.oauth;

import io.fusionauth.der.DerInputStream;
import io.fusionauth.der.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthUtils {
    static final Logger log = LoggerFactory.getLogger(OAuthUtils.class);

    private OAuthUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static RSAPublicKey loadPublicKey(String key) throws GeneralSecurityException {
        String publicKeyContent = key.replaceAll("\\n", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        KeyFactory kf = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyContent));
        RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(keySpecX509);
        return pubKey;
    }

    public static PrivateKey loadPrivateKey(String privateKeyPem) throws GeneralSecurityException, IOException {
        String PEM_PRIVATE_START = "-----BEGIN PRIVATE KEY-----";
        String PEM_PRIVATE_END = "-----END PRIVATE KEY-----";
        String PEM_RSA_PRIVATE_START = "-----BEGIN RSA PRIVATE KEY-----";
        String PEM_RSA_PRIVATE_END = "-----END RSA PRIVATE KEY-----";
        if (privateKeyPem.indexOf("-----BEGIN PRIVATE KEY-----") != -1) {
            privateKeyPem = privateKeyPem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "");
            privateKeyPem = privateKeyPem.replaceAll("\\s", "");
            byte[] pkcs8EncodedKey = Base64.getDecoder().decode(privateKeyPem);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(new PKCS8EncodedKeySpec(pkcs8EncodedKey));
        }
        if (privateKeyPem.indexOf("-----BEGIN RSA PRIVATE KEY-----") != -1) {
            privateKeyPem = privateKeyPem.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "");
            privateKeyPem = privateKeyPem.replaceAll("\\s", "");
            DerInputStream derReader = new DerInputStream(Base64.getDecoder().decode(privateKeyPem));
            DerValue[] seq = derReader.getSequence();
            if (seq.length < 9) {
                throw new GeneralSecurityException("Could not parse a PKCS1 private key.");
            }
            BigInteger modulus = seq[1].getBigInteger();
            BigInteger publicExp = seq[2].getBigInteger();
            BigInteger privateExp = seq[3].getBigInteger();
            BigInteger prime1 = seq[4].getBigInteger();
            BigInteger prime2 = seq[5].getBigInteger();
            BigInteger exp1 = seq[6].getBigInteger();
            BigInteger exp2 = seq[7].getBigInteger();
            BigInteger crtCoef = seq[8].getBigInteger();
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(keySpec);
        }
        throw new GeneralSecurityException("Not supported format of a private key");
    }
}

