/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.security;

import at.letto.lti.service.LTIDataService;
import at.letto.lti.service.LTIJWTService;
import at.letto.lti.utils.lti.LTI3Request;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.SignatureException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class LTI3OAuthProviderProcessingFilter
extends GenericFilterBean {
    LTIDataService ltiDataService;
    LTIJWTService ltijwtService;
    static final Logger log = LoggerFactory.getLogger(LTI3OAuthProviderProcessingFilter.class);

    public LTI3OAuthProviderProcessingFilter(LTIDataService ltiDataService, LTIJWTService ltijwtService) {
        if (ltiDataService == null) {
            throw new AssertionError();
        }
        this.ltiDataService = ltiDataService;
        if (ltijwtService == null) {
            throw new AssertionError();
        }
        this.ltijwtService = ltijwtService;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            throw new IllegalStateException("LTI request MUST be an HttpServletRequest (cannot only be a ServletRequest)");
        }
        try {
            Jws jws;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String state = httpServletRequest.getParameter("state");
            this.ltijwtService.validateState(state);
            String jwt = httpServletRequest.getParameter("id_token");
            if (StringUtils.hasText((String)jwt) && (jws = this.ltijwtService.validateJWT(jwt)) != null) {
                LTI3Request lti3Request = new LTI3Request(httpServletRequest, this.ltiDataService, true);
                httpServletRequest.setAttribute("LTI3", (Object)true);
                httpServletRequest.setAttribute("lti3_valid", (Object)(lti3Request.isLoaded() && lti3Request.isComplete() ? 1 : 0));
                httpServletRequest.setAttribute(LTI3Request.class.getName(), (Object)lti3Request);
            }
            filterChain.doFilter(servletRequest, servletResponse);
            this.resetAuthenticationAfterRequest();
        }
        catch (ExpiredJwtException eje) {
            log.info("Security exception for user {} - {}", (Object)eje.getClaims().getSubject(), (Object)eje.getMessage());
            ((HttpServletResponse)servletResponse).setStatus(401);
            log.debug("Exception " + eje.getMessage(), (Throwable)eje);
        }
        catch (SignatureException ex) {
            log.info("Invalid JWT signature: {0}", (Object)ex.getMessage());
            log.debug("Exception " + ex.getMessage(), (Throwable)ex);
            ((HttpServletResponse)servletResponse).setStatus(401);
        }
    }

    private void resetAuthenticationAfterRequest() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }
}

