/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.model.lti;

import at.letto.lti.dto.LTIplatformDTO;
import at.letto.lti.model.lti.BaseEntity;
import at.letto.lti.model.lti.LtiContextEntity;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="iss_configuration")
public class PlatformDeployment
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="key_id")
    private long keyId;
    @Basic
    @Column(name="iss", nullable=false, insertable=true, updatable=true)
    private String iss;
    @Basic
    @Column(name="client_id", nullable=false, insertable=true, updatable=true)
    private String clientId;
    @Basic
    @Column(name="oidc_endpoint", nullable=false, insertable=true, updatable=true)
    private String oidcEndpoint;
    @Basic
    @Column(name="jwks_endpoint", nullable=true, insertable=true, updatable=true)
    private String jwksEndpoint;
    @Basic
    @Column(name="oauth2_token_url", nullable=true, insertable=true, updatable=true)
    private String oAuth2TokenUrl;
    @Basic
    @Column(name="deployment_id", nullable=false, insertable=true, updatable=true)
    private String deploymentId;
    @Basic
    @Column(name="toolkid", nullable=true, insertable=true, updatable=true)
    private String toolKid;
    @Basic
    @Column(name="platformkid", nullable=true, insertable=true, updatable=true)
    private String platformKid;
    @OneToMany(mappedBy="platformDeployment", fetch=FetchType.LAZY)
    private Set<LtiContextEntity> contexts;

    public long getKeyId() {
        return this.keyId;
    }

    public void setKeyId(long keyId) {
        this.keyId = keyId;
    }

    public String getIss() {
        return this.iss;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getOidcEndpoint() {
        return this.oidcEndpoint;
    }

    public void setOidcEndpoint(String oidcEndpoint) {
        this.oidcEndpoint = oidcEndpoint;
    }

    public String getJwksEndpoint() {
        return this.jwksEndpoint;
    }

    public void setJwksEndpoint(String jwksEndpoint) {
        this.jwksEndpoint = jwksEndpoint;
    }

    public String getoAuth2TokenUrl() {
        return this.oAuth2TokenUrl;
    }

    public void setoAuth2TokenUrl(String oAuth2TokenUrl) {
        this.oAuth2TokenUrl = oAuth2TokenUrl;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getToolKid() {
        return this.toolKid;
    }

    public void setToolKid(String toolKid) {
        this.toolKid = toolKid;
    }

    public String getPlatformKid() {
        return this.platformKid;
    }

    public void setPlatformKid(String platformKid) {
        this.platformKid = platformKid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformDeployment that = (PlatformDeployment)o;
        if (this.keyId != that.keyId) {
            return false;
        }
        if (this.iss != null ? !this.iss.equals(that.iss) : that.iss != null) {
            return false;
        }
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        return this.deploymentId != null ? this.deploymentId.equals(that.deploymentId) : that.deploymentId == null;
    }

    public int hashCode() {
        int result = (int)this.keyId;
        result = 31 * result + (this.iss != null ? this.iss.hashCode() : 0);
        result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
        result = 31 * result + (this.oidcEndpoint != null ? this.oidcEndpoint.hashCode() : 0);
        result = 31 * result + (this.oAuth2TokenUrl != null ? this.oAuth2TokenUrl.hashCode() : 0);
        result = 31 * result + (this.deploymentId != null ? this.deploymentId.hashCode() : 0);
        result = 31 * result + (this.toolKid != null ? this.toolKid.hashCode() : 0);
        result = 31 * result + (this.platformKid != null ? this.platformKid.hashCode() : 0);
        return result;
    }

    public LTIplatformDTO toDto() {
        return new LTIplatformDTO(this.getKeyId(), this.getIss(), this.getClientId(), this.getOidcEndpoint(), this.getJwksEndpoint(), this.getoAuth2TokenUrl(), this.getDeploymentId(), this.getToolKid(), this.getPlatformKid());
    }

    public void mapDto(LTIplatformDTO dto) {
        this.setIss(dto.getIss());
        this.setClientId(dto.getClientId());
        this.setOidcEndpoint(dto.getOidcEndpoint());
        this.setJwksEndpoint(dto.getJwksEndpoint());
        this.setoAuth2TokenUrl(dto.getOauth2TokenUrl());
        this.setDeploymentId(dto.getDeploymentId());
        this.setToolKid(dto.getToolKid());
        this.setPlatformKid(dto.getPlatformKid());
    }
}

