/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.model.lti;

import at.letto.lti.model.lti.BaseEntity;
import at.letto.lti.model.lti.LtiResultEntity;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="lti_user")
public class LtiUserEntity
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="user_id", nullable=false, insertable=true, updatable=true)
    private long userId;
    @Basic
    @Column(name="user_key", nullable=false, insertable=true, updatable=true, length=4096)
    private String userKey;
    @Basic
    @Column(name="displayname", nullable=true, insertable=true, updatable=true, length=4096)
    private String displayName;
    @Basic
    @Column(name="email", nullable=true, insertable=true, updatable=true, length=255)
    private String email;
    @Basic
    @Column(name="locale", nullable=true, insertable=true, updatable=true, length=63)
    private String locale;
    @Basic
    @Column(name="subscribe", nullable=true, insertable=true, updatable=true)
    private Short subscribe;
    @Lob
    @Column(name="json", nullable=true, insertable=true, updatable=true, length=65535)
    private String json;
    @Basic
    @Column(name="login_at", nullable=false, insertable=true, updatable=true)
    private Timestamp loginAt;
    @OneToMany(mappedBy="user", fetch=FetchType.LAZY)
    private Set<LtiResultEntity> results;

    protected LtiUserEntity() {
    }

    public LtiUserEntity(String userKey, Date loginAt) {
        if (!StringUtils.isNotBlank((CharSequence)userKey)) {
            throw new AssertionError();
        }
        if (loginAt == null) {
            loginAt = new Date();
        }
        this.userKey = userKey;
        this.loginAt = new Timestamp(loginAt.getTime());
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Short getSubscribe() {
        return this.subscribe;
    }

    public void setSubscribe(Short subscribe) {
        this.subscribe = subscribe;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public Timestamp getLoginAt() {
        return this.loginAt;
    }

    public void setLoginAt(Timestamp loginAt) {
        this.loginAt = loginAt;
    }

    public Set<LtiResultEntity> getResults() {
        return this.results;
    }

    public void setResults(Set<LtiResultEntity> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtiUserEntity that = (LtiUserEntity)o;
        if (this.userId != that.userId) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        return this.userKey != null ? this.userKey.equals(that.userKey) : that.userKey == null;
    }

    public int hashCode() {
        int result = (int)this.userId;
        result = 31 * result + (this.userKey != null ? this.userKey.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }
}

