/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.database;

import at.letto.lti.config.ApplicationConfig;
import at.letto.lti.model.lti.LtiUserEntity;
import at.letto.lti.model.lti.PlatformDeployment;
import at.letto.lti.model.lti.RSAKeyEntity;
import at.letto.lti.repository.LtiUserRepository;
import at.letto.lti.repository.PlatformDeploymentRepository;
import at.letto.lti.repository.RSAKeyRepository;
import at.letto.tools.ENCRYPT;
import java.security.KeyPair;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!testing"})
public class DatabasePreload {
    static final Logger log = LoggerFactory.getLogger(DatabasePreload.class);
    @Autowired
    ApplicationConfig applicationConfig;
    @Autowired
    RSAKeyRepository rsaKeyRepository;
    @Autowired
    LtiUserRepository ltiUserRepository;
    @Autowired
    PlatformDeploymentRepository platformDeploymentRepository;

    @PostConstruct
    public void init() {
        if (this.rsaKeyRepository.count() > 0L) {
            log.info("INIT - no preload");
        } else {
            String ownPublicKey;
            String ownPrivateKey;
            log.info("INIT - preloaded keys and user");
            try {
                KeyPair keyPair = ENCRYPT.generateRSAkeypair();
                ownPrivateKey = "-----BEGIN PRIVATE KEY-----" + ENCRYPT.privateKeyBase64FromRSAkeypair((KeyPair)keyPair) + "-----END PRIVATE KEY-----";
                ownPublicKey = "-----BEGIN PUBLIC KEY-----" + ENCRYPT.publicKeyBase64FromRSAkeypair((KeyPair)keyPair) + "-----END PUBLIC KEY-----";
            }
            catch (Exception e) {
                throw new RuntimeException("Fehler! Der RSA-Key kann nicht erzeugt werden!!");
            }
            this.rsaKeyRepository.saveAndFlush((Object)new RSAKeyEntity("OWNKEY", Boolean.valueOf(true), ownPublicKey, ownPrivateKey));
            PlatformDeployment iss1 = new PlatformDeployment();
            iss1.setClientId("pXJLlyTGGsGAvYD");
            iss1.setIss("http://localhost/moodle");
            iss1.setOidcEndpoint("http://localhost/moodle/mod/lti/auth.php");
            iss1.setDeploymentId("1");
            iss1.setToolKid("Letto");
            iss1.setPlatformKid("ae0363b9b4ad41fc8aa3");
            iss1.setoAuth2TokenUrl("http://localhost/moodle/mod/lti/token.php");
            iss1.setJwksEndpoint("http://localhost/moodle/mod/lti/certs.php");
            String tool2PrivateString = "-----BEGIN PRIVATE KEY-----MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQC2QJCkV2gFoQD2z7dQRq7g5qIxPaZJJZAJ07wPxdAJiyuWbo0bMOvH//5IqmOnUdal7iNYtDKwr9Cx6UMqI34q6b080GPypyl058vR7Z31ZNv9d4csp81DJxW9UcSkuqTWbEDRvoHUXJLtmhO+CokQSkS2oM1mWQeV1r3T73zPUsUq/QinK8SgGamFb+TbWQOIbqCymKwnt0no2Vg7bqfelkAWXAIMBo9WoiNDiT7v3Ns7Fu8NJ64stXSYC8zzmTWbiUkx06SbJOKzH0HC9NqZmeOwcDyStXYt6mVJg+bOtpctuikCZIkYeJuEwWkR9LqvAdoCs1kVnq8kF1alNd35AgMBAAECggEALBamZvs2ENaIEyzgnazbtVBVwC+3wE4z8Aymm/Iwh36BRtzrib5l63YEH7QIc3uav31CU70T3iZKCB/zvYfkh6EPxFxtMVA6+Srx5ZDj+28wwLpfmu/k+e/ElI3pUihMpAqAC71YTvUuHgh96iVGTwiIYt23kqDK8vaF6XUv7j8hD1do+4eX9oZM03dqh2cZfC1z+xdhiEQzEOSu7qcNhml6d/rpS0EkILnmBekA1adwUuaS/FQzcbggScSGtL2WL6CFB1gl82IGhJALqRASfRGWlkmlnTQ1fzYZdLLvWKlGMM1mWu3zmOGxNSKQwpEHlxDpSxemFAf7RkgavA5EeQKBgQDihvyG1Ba9xtW9jO80BPCpvyCmpX0SlhlP7kYKtZHqkEKd+SOvfzN8fxi/5BNRXnMmJFN3Mkc2sYssMzTxMABii2e6r02AwkLUBu2DX5O/qauCbVlhr1LtvMbKTw6jnJYpGkZMqnTTS/933DPD8xa8AsckFMsXiGRs9OpFpOF+cwKBgQDN9uUVbarh3o6xx4pABNp3QDLQeqllUlsrZ4JqX26MELE1hA5qaccaLMtSY5Pq8Qh36tQJhZFAYz3isxvEhhIkAZZKmKi9MKDKlf+u7vYWfpNYxUPwpB9ZRM4UCcquY24/FgKucorQI0KwYqOTJX2whKDBjiurINA2x658s5TK4wKBgAQqQThla+mfX0y166wELzyfxATsZAlUczCyC92kiwNKFb971jki2JqAZ78XfXdwiiN4ZYR6iy6pQwrUAjQxEsC9GXIoSP+GEt59Jh7VQg0zHHEwe4U9SQQQBYOwwm8lsOkej45XUACWlCLrDJScwp1AW9MBAt7y5g3OzwPqzS6bAoGAFoVOmz84liX9uFa3OTTOpodwhvdCmn+c1GwnCHaS4eHZXp6n7N7QFH6dZM7al6/vWx1kPf5K2Z2AYM9w09ZNGX7K7jEvEjDFBCHOqVQbuG3yspwvR5rKirpJRkujy9m3blJ7zJNdtlCEtEC03hwVWD3ITiG7iKS336WJ4LzKIj0CgYBhhcvs9rnEx0pbMPyw3eK+v2utJ02u3MsWmynJbvjqTSwZhRfBlDA2uzOLvPUNNOWiGjExCrAe+fFkuO8l72wuT8RzsVTPwN9uKZOlm/sHd7KtETaMXRM94mT/uisQ9QahX48tw/c4miu+Sv2xWwQ1sNJ4OXzO/tir0uLgMp6XcA==-----END PRIVATE KEY-----";
            String tool2PublicString = "-----BEGIN PUBLIC KEY-----MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtkCQpFdoBaEA9s+3UEau4OaiMT2mSSWQCdO8D8XQCYsrlm6NGzDrx//+SKpjp1HWpe4jWLQysK/QselDKiN+Kum9PNBj8qcpdOfL0e2d9WTb/XeHLKfNQycVvVHEpLqk1mxA0b6B1FyS7ZoTvgqJEEpEtqDNZlkHlda90+98z1LFKv0IpyvEoBmphW/k21kDiG6gspisJ7dJ6NlYO26n3pZAFlwCDAaPVqIjQ4k+79zbOxbvDSeuLLV0mAvM85k1m4lJMdOkmyTisx9BwvTamZnjsHA8krV2LeplSYPmzraXLbopAmSJGHibhMFpEfS6rwHaArNZFZ6vJBdWpTXd+QIDAQAB-----END PUBLIC KEY-----";
            LtiUserEntity user = (LtiUserEntity)this.ltiUserRepository.saveAndFlush((Object)new LtiUserEntity("testuser", null));
            this.ltiUserRepository.saveAndFlush((Object)user);
        }
    }
}

