/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.controller;

import at.letto.dto.RestDTO;
import at.letto.dto.RestStatus;
import at.letto.dto.StringRestDTO;
import at.letto.lti.dto.LTIKeyListRestDTO;
import at.letto.lti.dto.LTILettoPublicRestDTO;
import at.letto.lti.dto.LTIPlatformListRestDTO;
import at.letto.lti.dto.LTIPlatformRestDTO;
import at.letto.lti.dto.LTIRestkeyRestDTO;
import at.letto.lti.dto.LTIRsaKeyRestDTO;
import at.letto.lti.service.LTIConfigurationService;
import at.letto.lti.service.LTIDataService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/letto"})
public class LettoLoginController {
    @Autowired
    LTIDataService ltiDataService;
    @Autowired
    LTIConfigurationService ltiConfigurationService;

    @PostMapping(value={"/ping"})
    public ResponseEntity<RestDTO> ping(@RequestBody RestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1) {
            dto.reststatusOK();
        } else if (dto.getRestkey().equals(restkey)) {
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/setrestkey"})
    public ResponseEntity<LTIRestkeyRestDTO> setRestKey(@RequestBody LTIRestkeyRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiConfigurationService.setRestKey(dto.getNewRestkey());
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/getrestkey"})
    public ResponseEntity<LTIRestkeyRestDTO> getRestKey(@RequestBody LTIRestkeyRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            dto.setRestkey(this.ltiConfigurationService.getRestKey());
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/setlettopublic"})
    public ResponseEntity<LTILettoPublicRestDTO> setLettoPublicKey(@RequestBody LTILettoPublicRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiConfigurationService.setLettoPublicKey(dto.getLettoPublicKey());
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/getlettopublic"})
    public ResponseEntity<LTILettoPublicRestDTO> getLettoPublicKey(@RequestBody LTILettoPublicRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            dto.setLettoPublicKey(this.ltiConfigurationService.getLettoPublicKey());
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/setlettoserver"})
    public ResponseEntity<StringRestDTO> setLettoServer(@RequestBody StringRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiConfigurationService.setLettoServer(dto.getData());
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/getlettoserver"})
    public ResponseEntity<StringRestDTO> getLettoServer(@RequestBody RestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        StringRestDTO ret = new StringRestDTO(dto.getRestkey(), "");
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            ret.setData(this.ltiConfigurationService.getLettoServer());
            ret.reststatusOK();
        } else {
            ret.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)ret);
    }

    @PostMapping(value={"/getrsakeys"})
    public ResponseEntity<LTIKeyListRestDTO> getRsaKeys(@RequestBody RestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        LTIKeyListRestDTO ret = new LTIKeyListRestDTO(dto.getRestkey());
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiDataService.getRsaKeys(ret.getLtiRsaKeys());
            ret.reststatusOK();
        } else {
            ret.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)ret);
    }

    @PostMapping(value={"/setrsakey"})
    public ResponseEntity<LTIRsaKeyRestDTO> setRsaKey(@RequestBody LTIRsaKeyRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            dto.setLtiRsaKey(this.ltiDataService.setRsaKey(dto.getLtiRsaKey()));
            if (dto.getLtiRsaKey() == null) {
                dto.setReststatus(RestStatus.FORBIDDEN, "Key konnte nicht gespeichert werden");
            } else {
                dto.reststatusOK();
            }
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/removersakey"})
    public ResponseEntity<RestDTO> removeRsaKey(@RequestBody LTIRsaKeyRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        RestDTO result = new RestDTO(dto.getRestkey());
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiDataService.removeRsaKey(dto.getLtiRsaKey());
            result.reststatusOK();
        } else {
            result.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/getplatforms"})
    public ResponseEntity<LTIPlatformListRestDTO> getPlatforms(@RequestBody RestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        LTIPlatformListRestDTO ret = new LTIPlatformListRestDTO(dto.getRestkey());
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiDataService.getPlatforms(ret.getPlatforms());
            ret.reststatusOK();
        } else {
            ret.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)ret);
    }

    @PostMapping(value={"/setplatform"})
    public ResponseEntity<LTIPlatformRestDTO> getRsaKeys(@RequestBody LTIPlatformRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            dto.setLtIplatformDTO(this.ltiDataService.setPlatform(dto.getLtIplatformDTO()));
            if (dto.getLtIplatformDTO() == null) {
                dto.setReststatus(RestStatus.FORBIDDEN, "Platform konnte nicht gespeichert werden");
            } else {
                dto.reststatusOK();
            }
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/removeplatform"})
    public ResponseEntity<RestDTO> removePlatform(@RequestBody LTIPlatformRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        RestDTO result = new RestDTO(dto.getRestkey());
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiDataService.removePlatform(dto.getLtIplatformDTO());
            result.reststatusOK();
        } else {
            result.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/callcommand"})
    public ResponseEntity<StringRestDTO> callcommand(@RequestBody StringRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            dto.setData(this.ltiConfigurationService.callcommand(dto.getData()));
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/activatewatchdog"})
    public ResponseEntity<StringRestDTO> activateWatchdog(@RequestBody StringRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            String s = dto.getData();
            int time = 0;
            String url = "";
            Pattern p = Pattern.compile("^([\\+\\-]?\\d+):(.*)$");
            Matcher m = p.matcher(s.trim());
            if (m.find()) {
                time = Integer.parseInt(m.group(1));
                url = m.group(2);
                this.ltiConfigurationService.activateWatchdog(time, url);
                dto.reststatusOK();
            } else {
                dto.setReststatus(RestStatus.INKONSISTENT, "Watchdog konnte nicht gestartet werden!!");
            }
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/iswatchdogactive"})
    public ResponseEntity<StringRestDTO> isWatchdogActive(@RequestBody StringRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            String s = dto.getData();
            boolean time = false;
            String url = "";
            if (this.ltiConfigurationService.isWatchdogActive()) {
                dto.reststatusOK();
            } else {
                dto.setReststatus(RestStatus.INKONSISTENT, "Watchdog nicht aktiv!!");
            }
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/testwatchdog"})
    public ResponseEntity<StringRestDTO> testWatchdog(@RequestBody StringRestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            String s = dto.getData();
            int time = 0;
            String url = "";
            Pattern p = Pattern.compile("^([\\+\\-]?\\d+):(.*)$");
            Matcher m = p.matcher(s.trim());
            if (m.find()) {
                time = Integer.parseInt(m.group(1));
                url = m.group(2);
                if (this.ltiConfigurationService.testWatchdog(url)) {
                    dto.reststatusOK();
                } else {
                    dto.setReststatus(RestStatus.INKONSISTENT, "Watchdog konnte nicht gestartet werden!!");
                }
            } else {
                dto.setReststatus(RestStatus.INKONSISTENT, "Watchdog konnte nicht gestartet werden!!");
            }
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @PostMapping(value={"/deactivatewatchdog"})
    public ResponseEntity<RestDTO> deactivateWatchdog(@RequestBody RestDTO dto) {
        String restkey = this.ltiConfigurationService.getRestKey();
        if (restkey == null || restkey.length() < 1 || dto.getRestkey().equals(restkey)) {
            this.ltiConfigurationService.deactivateWatchdog();
            dto.reststatusOK();
        } else {
            dto.setReststatus(RestStatus.FORBIDDEN, "Falscher RestKey!!");
        }
        return ResponseEntity.ok((Object)dto);
    }
}

