/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.controller;

import at.letto.lti.dto.LTIconnectionDTO;
import at.letto.lti.dto.LoginDataDTO;
import at.letto.lti.service.LTIConfigurationService;
import at.letto.lti.service.LTIJWTService;
import at.letto.lti.utils.lti.LTI3Request;
import at.letto.tools.ENCRYPT;
import at.letto.tools.JSON;
import io.jsonwebtoken.SignatureException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/lti3"})
public class LTI3Controller {
    @Autowired
    LTIJWTService ltijwtService;
    @Autowired
    LTIConfigurationService ltiConfigurationService;

    @RequestMapping(value={"", "/"})
    public String home(HttpServletRequest req, Model model) {
        String postData = "";
        try {
            postData = StreamUtils.copyToString((InputStream)req.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String state = req.getParameter("state");
        String link = req.getParameter("link");
        try {
            this.ltijwtService.validateState(state);
            LoginDataDTO loginData = this.ltijwtService.getLoginDataFromJWT(req.getParameter("id_token"));
            String lettokey = this.ltiConfigurationService.getLettoPublicKey();
            LTIconnectionDTO ltIconnectionDTO = new LTIconnectionDTO(this.ltijwtService.getId(), loginData, System.currentTimeMillis(), req.getParameter("id_token"));
            String jsondata = JSON.objToJson((Object)ltIconnectionDTO);
            String passphrase = ENCRYPT.md5falsch((String)(Math.random() + jsondata));
            String token = ENCRYPT.encryptTextRSApublic((String)passphrase, (String)lettokey);
            String data = ENCRYPT.enc((String)jsondata, (String)passphrase);
            String tokenURL = ENCRYPT.base64toBase64URL((String)token);
            String dataURL = ENCRYPT.base64toBase64URL((String)data);
            LTI3Request lti3Request = LTI3Request.getInstance();
            model.addAttribute("url", (Object)(this.ltiConfigurationService.getLettoServer() + "?token=" + tokenURL + "&data=" + dataURL));
            if (loginData.getLinktext().length() > 0) {
                model.addAttribute("linktext", (Object)loginData.getLinktext());
            } else {
                model.addAttribute("linktext", (Object)"Verbinden mit Letto");
            }
            if (loginData.getTarget().length() > 0) {
                model.addAttribute("target", (Object)loginData.getLinktext());
            } else {
                model.addAttribute("target", (Object)"_blank");
            }
            model.addAttribute("status1", (Object)("Moodle Kurs:" + loginData.getMoodlekurs() + " ID:" + loginData.getMoodlekursId()));
            model.addAttribute("status2", (Object)("Loginname:" + loginData.getName()));
            model.addAttribute("status3", (Object)"");
            return "lti3Result";
        }
        catch (SignatureException ex) {
            model.addAttribute("Error", (Object)ex.getMessage());
            return "lti3Error";
        }
    }
}

