/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.config;

import org.apache.catalina.connector.Connector;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.ErrorPageRegistrar;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
public class TomcatConfiguration {
    private static final String PROTOCOL = "AJP/1.3";
    @Value(value="${tomcat.ajp.port:9099}")
    private int ajpPort;

    @Bean
    public WebServerFactoryCustomizer<TomcatServletWebServerFactory> servletContainer() {
        return server -> {
            if (server instanceof TomcatServletWebServerFactory) {
                server.addAdditionalTomcatConnectors(new Connector[]{this.redirectConnector()});
            }
        };
    }

    @Bean
    public ErrorPageRegistrar errorPageRegistrar() {
        return registry -> registry.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.NOT_FOUND, "/oidc/error"), new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/oidc/error")});
    }

    private Connector redirectConnector() {
        Connector connector = new Connector(PROTOCOL);
        connector.setScheme("http");
        connector.setPort(this.ajpPort);
        connector.setSecure(false);
        connector.setAllowTrace(false);
        return connector;
    }
}

