/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.config;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class ApplicationConfig
implements ApplicationContextAware {
    static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private static final Object contextLock = new Object();
    private static final Object configLock = new Object();
    private static volatile ApplicationContext context;
    private static volatile ApplicationConfig config;
    @Autowired
    ConfigurableEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        log.info("INIT");
        this.env.setActiveProfiles(new String[]{"dev", "testing"});
        Object object = configLock;
        synchronized (object) {
            config = this;
        }
        log.info("Config INIT: profiles active: {0}.", (Object)ArrayUtils.toString((Object)this.env.getActiveProfiles()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void shutdown() {
        Object object = contextLock;
        synchronized (object) {
            context = null;
        }
        object = configLock;
        synchronized (object) {
            config = null;
        }
        log.info("DESTROY");
    }

    public ConfigurableEnvironment getEnvironment() {
        return this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationContext(ApplicationContext applicationContext) {
        Object object = contextLock;
        synchronized (object) {
            context = applicationContext;
        }
    }

    public static ApplicationContext getContext() {
        return context;
    }

    public static ApplicationConfig getInstance() {
        return config;
    }
}

